/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.customweb.sever;

import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpRequest;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpResponse;
import cn.com.duiba.kjy.base.customweb.web.handler.DispatcherHandler;
import cn.com.duiba.kjy.base.customweb.web.handler.exception.ExceptionChain;
import cn.com.duiba.kjy.base.customweb.web.handler.response.impl.JacksonHandler;
import com.dianping.cat.Cat;
import com.dianping.cat.message.internal.DefaultTransaction;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StopWatch;

public class KjjChannelInboundHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private static final Logger log = LoggerFactory.getLogger(KjjChannelInboundHandler.class);
    private final DispatcherHandler dispatcherHandler;
    private final ExceptionChain exceptionChain;
    public static final AtomicInteger count = new AtomicInteger(0);
    public static final AtomicInteger count1 = new AtomicInteger(0);
    public static final AtomicLong time = new AtomicLong(0L);
    public static final AtomicLong time1 = new AtomicLong(0L);
    public static final AtomicLong requestResponseTime = new AtomicLong(0L);

    public KjjChannelInboundHandler(DispatcherHandler dispatcherHandler, ExceptionChain exceptionChain) {
        this.dispatcherHandler = dispatcherHandler;
        this.exceptionChain = exceptionChain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void channelRead0(ChannelHandlerContext ctx, FullHttpRequest httpRequest) throws Exception {
        DefaultTransaction webUrlTransaction = (DefaultTransaction)Cat.newTransaction((String)"NETTY", (String)"channel");
        try {
            this.doReader(ctx, httpRequest);
        }
        finally {
            webUrlTransaction.setStatus("0");
            webUrlTransaction.complete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doReader(ChannelHandlerContext ctx, FullHttpRequest httpRequest) {
        if (httpRequest.uri().equals("/netty")) {
            count1.incrementAndGet();
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            ByteBuf buffer = ctx.alloc().buffer();
            buffer.writeCharSequence((CharSequence)"{\"success\":true,\"code\":\"000000\",\"desc\":\"OK\",\"timestamp\":1618298528296,\"data\":{\"liveStatus\":4,\"lotteryFlag\":false}}", Charset.defaultCharset());
            DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, buffer);
            ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            stopWatch.stop();
            time1.addAndGet(stopWatch.getTotalTimeNanos());
            return;
        }
        if (httpRequest.uri().equals("/time")) {
            ByteBuf buffer = ctx.alloc().buffer();
            String sequence = "restful time:" + time.getAndSet(0L) + "\ncount=" + count.getAndSet(0) + "\n";
            String sequence2 = "netty time:" + time1.getAndSet(0L) + "\ncount=" + count1.getAndSet(0) + "\n";
            String sequence4 = "reqRes time:" + requestResponseTime.getAndSet(0L) + "\n";
            String sequence3 = "seri time:" + JacksonHandler.time.getAndSet(0L) + "\ncount=" + JacksonHandler.count.getAndSet(0) + "\n";
            buffer.writeCharSequence((CharSequence)(sequence + sequence2 + sequence4 + sequence3), Charset.defaultCharset());
            DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, buffer);
            ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            return;
        }
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        KjjHttpRequest request = new KjjHttpRequest(ctx, httpRequest);
        KjjHttpResponse response = new KjjHttpResponse(ctx, httpRequest);
        stopWatch.stop();
        stopWatch.start();
        requestResponseTime.addAndGet(stopWatch.getTotalTimeMillis());
        try {
            this.dispatcherHandler.handler(request, response);
        }
        catch (Throwable e) {
            this.exceptionChain.handlerException(request, response, e);
        }
        finally {
            try {
                if (request.isSync() && !response.isClosed()) {
                    log.error("request where uri = {} is not closed right!", (Object)httpRequest.uri());
                    response.setContentType(ContentType.TEXT_PLAIN.getMimeType());
                    response.setStatus(HttpResponseStatus.SERVICE_UNAVAILABLE);
                    response.write("NO RESPONSE");
                    response.flushAndClose();
                }
            }
            catch (Exception e) {
                log.error("request disaster tolerance has error! this must be joker!", (Throwable)e);
            }
            finally {
                stopWatch.stop();
                time.addAndGet(stopWatch.getTotalTimeNanos());
                count.incrementAndGet();
            }
        }
    }

    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        super.channelRegistered(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        log.error("channel has exception = {}", (Object)ctx.channel(), (Object)cause);
        ctx.close();
    }
}

