package cn.com.duiba.kjy.base.api.bean.es;

import lombok.Data;
import lombok.EqualsAndHashCode;
import org.elasticsearch.search.sort.SortOrder;

/**
 * @author linjianhui
 * @description 排序条件
 * @date 2020-02-07 15:33
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class SortCriteria extends BaseCriteria {
    private static final long serialVersionUID = 3737059812059733570L;
    /**
     * 字段名
     */
    private String fieldName;
    /**
     * 是否倒序
     */
    private SortOrder sort;
    /**
     * 下一个排序条件
     */
    private SortCriteria sortCriteria;

    public SortCriteria(String fieldName) {
        this(fieldName, false);
    }

    public SortCriteria(String fieldName, boolean isDesc) {
        this.fieldName = fieldName;
        this.sort = isDesc? SortOrder.DESC:SortOrder.ASC;
    }

    public SortCriteria getNext(){
        return sortCriteria;
    }

    public SortCriteria setNext(SortCriteria sortCriteria) {
        this.sortCriteria = sortCriteria;
        return sortCriteria;
    }
}
