package cn.com.duiba.kjy.base.api.param.lottery;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author zhanghuifeng
 * date 2021/1/28-13:46
 */
@Data
public class LiveRewardLotteryCollectParam implements Serializable {
    private static final long serialVersionUID = -4179389213066060020L;

    /**
     * 直播用户ID
     */
    private Long liveUserId;

    /**
     * 用户授权的手机号
     */
    private String authPhone = "";

    /**
     * 抽奖码数量
     */
    private Integer lotteryCodeNum = 0;

    /**
     * 时长
     */
    private Long duration = 0L;

    /**
     * 代理人ID
     */
    private Long agentId;

    /**
     * 直播ID
     */
    private Long liveId;

    /**
     * 操作类型
     * @see cn.com.duiba.kjy.base.api.enums.lottery.LiveRewardLotteryCollectEnum
     */
    private Integer type;

    /**
     * 是否到场：0-未到场，1-已到场
     */
    private Integer present;

    /**
     * 访客用户id集合，成为代理人事件/进入黑名单事件会有值
     */
    private List<Long> visitorIds;

    /**
     * 直播ids集合
     * 退出公司会有值
     */
    private List<Long> liveIds;

    /**
     * 中奖类型 1普通抽奖 2代理人指定中奖 3企业指定中奖
     */
    private Integer drawType;

    /**
     * 用户提交表单选项id集合
     */
    private List<Long> optionIds;

    /**
     * 是否是直接邀请
     */
    private Integer isDirectly;

    /**
     * 优先级得分（暂时只支持正整数）
     */
    private Integer priorityScore;

}
