package cn.com.duiba.kjy.base.customweb.autoconfig;

import cn.com.duiba.kjy.base.customweb.sever.NettyServerConfigurationProperties;
import cn.com.duiba.kjy.base.customweb.web.factory.FilterChainFactory;
import cn.com.duiba.kjy.base.customweb.web.filter.ActuateFilter;
import cn.com.duiba.kjy.base.customweb.web.filter.CustomCatWebFilter;
import cn.com.duiba.kjy.base.customweb.web.filter.KjjAccessLogFilter;
import cn.com.duiba.kjy.base.customweb.web.filter.MonitorFilter;
import cn.com.duiba.kjy.base.customweb.web.processor.FilterBeanPostProcessor;
import cn.com.duibaboot.ext.autoconfigure.accesslog.AbstractAccessLogFilter;
import com.dianping.cat.Cat;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.beans.BeansEndpoint;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnResource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * @author dugq
 * @date 2021/3/28 11:38 下午
 */
@Configuration
@AutoConfigureBefore(NettyAutoConfiguration.class)
@ConditionalOnBean(NettyServerConfigurationProperties.class)
public class FilterAutoConfig {

    @Bean
    public FilterChainFactory filterChainFactory(){
        return new FilterChainFactory();
    }

    @Bean
    public static FilterBeanPostProcessor filterBeanPostProcessor(){
        return new FilterBeanPostProcessor();
    }


    @Bean
    public MonitorFilter monitorFilter(){
        return new MonitorFilter();
    }

    @Bean
    public ActuateFilter actuateFilter(ObjectProvider<BeansEndpoint> beansEndpoint){
        final BeansEndpoint beansEndpoint1 = beansEndpoint.getIfAvailable();
        return new ActuateFilter(beansEndpoint1);
    }

    @Bean
    @ConditionalOnClass(Cat.class)
    @ConditionalOnProperty(prefix = "server",name = "catWeb",havingValue = "true")
    public CustomCatWebFilter customCatWebFilter(){
        return new CustomCatWebFilter();
    }

    @Bean
    @ConditionalOnClass(AbstractAccessLogFilter.class)
    @ConditionalOnResource(resources = "classpath:logback/access-logback.xml")
    public KjjAccessLogFilter kjjAccessLogFilter(){
        return new KjjAccessLogFilter();
    }
}
