package cn.com.duiba.kjy.base.customweb.sever;

import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpRequest;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpResponse;
import cn.com.duiba.kjy.base.customweb.web.filter.CustomFilterChain;
import cn.com.duiba.kjy.base.customweb.web.filter.KjjAccessLogFilter;
import cn.com.duiba.kjy.base.customweb.web.handler.DispatcherHandler;
import cn.com.duiba.kjy.base.customweb.web.handler.exception.ExceptionChain;
import cn.com.duiba.kjy.base.customweb.web.handler.response.impl.JacksonHandler;
import com.dianping.cat.Cat;
import com.dianping.cat.message.internal.DefaultTransaction;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.entity.ContentType;
import org.springframework.util.StopWatch;

import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

/**
 * @author dugq
 * @date 2020-08-10 17:35
 */
@Slf4j
public class KjjChannelInboundHandler extends SimpleChannelInboundHandler<FullHttpRequest> {

    private final DispatcherHandler dispatcherHandler;
    private final ExceptionChain exceptionChain;
    public static final AtomicInteger count = new AtomicInteger(0);
    public static final AtomicInteger count1 = new AtomicInteger(0);
    public static final AtomicLong time = new AtomicLong(0);
    public static final AtomicLong time1 = new AtomicLong(0);

    public static final AtomicLong requestResponseTime = new AtomicLong(0);

    public KjjChannelInboundHandler(DispatcherHandler dispatcherHandler,ExceptionChain exceptionChain) {
        this.dispatcherHandler = dispatcherHandler;
        this.exceptionChain = exceptionChain;
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, FullHttpRequest httpRequest) throws Exception {
        DefaultTransaction webUrlTransaction = (DefaultTransaction) Cat.newTransaction("NETTY", "channel");
        try {
            doReader(ctx, httpRequest);
        }finally {
            webUrlTransaction.setStatus("0");
            webUrlTransaction.complete();
        }
    }

    private void doReader(ChannelHandlerContext ctx, FullHttpRequest httpRequest) {

        if (httpRequest.uri().equals("/netty")){
            count1.incrementAndGet();
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            final ByteBuf buffer = ctx.alloc().buffer();
            buffer.writeCharSequence("{\"success\":true,\"code\":\"000000\",\"desc\":\"OK\",\"timestamp\":1618298528296,\"data\":{\"liveStatus\":4,\"lotteryFlag\":false}}", Charset.defaultCharset());
            FullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK,buffer);
            ctx.writeAndFlush(response).addListener(ChannelFutureListener.CLOSE);
            stopWatch.stop();
            time1.addAndGet(stopWatch.getTotalTimeNanos());
            return;
        }

        final String uri = httpRequest.uri();
        if (StringUtils.equals("/monitor/check",uri)){
            final ByteBuf buffer = ctx.alloc().buffer();
            buffer.writeCharSequence("success", Charset.defaultCharset());
            FullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK,buffer);
            ctx.writeAndFlush(response).addListener(ChannelFutureListener.CLOSE);
            return;
        }

        if (httpRequest.uri().equals("/time")){
            final ByteBuf buffer = ctx.alloc().buffer();
            final String sequence = "all time:" +time.getAndSet(0)+" count="+count.getAndSet(0)+"\n";
            final String sequence1 = "new request time:" + requestResponseTime.getAndSet(0)+"\n";
            final String sequence2 = "filter count = "+ CustomFilterChain.count.getAndSet(0) +"  before time = "+ CustomFilterChain.beforeTime.getAndSet(0) +"  after time = "+CustomFilterChain.afterTime.getAndSet(0) + "\n";
            final String sequence3 = "access log count = "+KjjAccessLogFilter.count.getAndSet(0) +"  before time = "+ KjjAccessLogFilter.beforeTime.getAndSet(0) +"  after time = "+KjjAccessLogFilter.afterTime.getAndSet(0) + "\n";
            final String sequence4 = "interceptor chain time:" + DispatcherHandler.interceptorTime.getAndSet(0)+"\n";
            final String sequence5 = "api invoker time:" + DispatcherHandler.apiTime.getAndSet(0)+" count="+DispatcherHandler.apiCount.getAndSet(0)+"\n";
            final String sequence6 = "seri time:" + JacksonHandler.time.getAndSet(0)+" count="+JacksonHandler.count.getAndSet(0)+"\n";
            final String sequence7 = "netty time:" + time1.getAndSet(0)+" count="+count1.getAndSet(0)+"\n";

            buffer.writeCharSequence(sequence+sequence1+sequence2+sequence3+sequence4+sequence5+sequence6+sequence7, Charset.defaultCharset());
            FullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK,buffer);
            ctx.writeAndFlush(response).addListener(ChannelFutureListener.CLOSE);
            return;
        }

        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        KjjHttpRequest request = new KjjHttpRequest(ctx, httpRequest);
        KjjHttpResponse response = new KjjHttpResponse(ctx, httpRequest);
        stopWatch.stop();
        stopWatch.start();
        requestResponseTime.addAndGet(stopWatch.getTotalTimeMillis());
        try {
            dispatcherHandler.handler(request,response);
        }catch (Throwable e){
            exceptionChain.handlerException(request,response,e);
        }finally {
            try {
                if (request.isSync() && !response.isClosed()){
                    log.error("request where uri = {} is not closed right!", httpRequest.uri());
                    response.setContentType(ContentType.TEXT_PLAIN.getMimeType());
                    response.setStatus(HttpResponseStatus.SERVICE_UNAVAILABLE);
                    response.write("NO RESPONSE");
                    response.flushAndClose();
                }
            }catch (Exception e){
                log.error("request disaster tolerance has error! this must be joker!",e);
            }finally {
                stopWatch.stop();
                time.addAndGet(stopWatch.getTotalTimeNanos());
                count.incrementAndGet();
            }
        }
    }

    @Override
    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        super.channelRegistered(ctx);
    }

    /**
     * 通道关闭
     */
    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
    }

    /**
     * 通道可以使用
     */
    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
    }

    /**
     * web内部的所有异常应该在 {@link #channelRead0}中被完全处理掉。
     * 到达这里的应该是请求通道建立本身发生错误，如若不是，那么问题就大了
     */
    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        log.error("channel has exception = {}",ctx.channel(),cause);
        ctx.close();
    }
}
