package cn.com.duiba.kjy.base.customweb.web.factory;

import cn.com.duiba.kjy.base.customweb.web.filter.CustomFilter;
import cn.com.duiba.kjy.base.customweb.web.filter.CustomFilterChain;
import cn.com.duiba.kjy.base.customweb.web.handler.DispatcherHandler;
import lombok.extern.slf4j.Slf4j;

import java.util.ArrayList;
import java.util.List;

/**
 * @author dugq
 * @date 2021/3/25 1:43 下午
 */
@Slf4j
public class FilterChainFactory {

    private static final List<CustomFilter> FILTER_LIST = new ArrayList<>();

    public CustomFilterChain getInstance(DispatcherHandler dispatcherHandler) {
        return new CustomFilterChain(FILTER_LIST, dispatcherHandler);
    }

    public void addFilter(CustomFilter customFilter){
        FILTER_LIST.add(customFilter);
    }
}
