package cn.com.duiba.kjy.base.customweb.web.filter;

import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpRequest;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpResponse;
import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.feign.CustomRequestInterceptor;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import com.dianping.cat.Cat;
import com.dianping.cat.CatConstants;
import com.dianping.cat.message.Message;
import com.dianping.cat.message.internal.DefaultTransaction;

/**
 * @author dugq
 * @date 2021/3/21 11:15 上午
 */
public class CustomCatWebFilter implements CustomFilter {


    private void recordInCatTransaction(KjjHttpRequest request, long catStartTime, Throwable throwable){
        //记录应用-url级别的transaction
        String path = request.getUri().getPath();
        DefaultTransaction webUrlTransaction = (DefaultTransaction) Cat.newTransaction(CatConstants.TYPE_URL, path);
        webUrlTransaction.setDurationStart(catStartTime);
        try {
            Throwable exToLog = throwable;
            if (exToLog == null) {
                webUrlTransaction.setStatus(Message.SUCCESS);
            } else {
                webUrlTransaction.setStatus(exToLog);
                Cat.logError(exToLog);
            }
        } finally {
            webUrlTransaction.complete();
        }
    }

    @Override
    public void doFilter(CustomFilterChain customFilterChain, KjjHttpRequest httpRequest, KjjHttpResponse response) throws Throwable {
        if(!CatUtils.isCatEnabled()){
            customFilterChain.filter(httpRequest, response);
        }

        if ("true".equals(httpRequest.headers().get(CustomRequestInterceptor.X_RPC))) {
            //不处理RPC请求（来自FeignClient的rest rpc调用）
            customFilterChain.filter(httpRequest, response);
        }

        //记录开始时间
        final long startTime = System.nanoTime();
        try {
            customFilterChain.filter(httpRequest, response);
            recordInCatTransaction(httpRequest, startTime, null);
        }catch (Throwable e){
            recordInCatTransaction(httpRequest, startTime, e);
            throw e;
        }
    }
}
