package cn.com.duiba.kjy.base.customweb.web.filter;

import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpRequest;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpResponse;
import cn.com.duiba.kjy.base.customweb.web.handler.DispatcherHandler;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.util.StopWatch;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

/**
 * @author dugq
 * @date 2021/3/25 11:08 上午
 */
public class CustomFilterChain {

    public static final AtomicInteger count = new AtomicInteger(0);
    public static final AtomicLong time = new AtomicLong(0);
    public static final AtomicLong beforeTime = new AtomicLong(0);
    public static final AtomicLong afterTime = new AtomicLong(0);

    private final List<CustomFilter> filterList;
    private int pos;
    private int size;
    private final DispatcherHandler dispatcherHandler;
    private StopWatch beforeStopWatch;
    private StopWatch afterStopWatch;

    public CustomFilterChain(List<CustomFilter> filterList, DispatcherHandler dispatcherHandler) {
        this.filterList = filterList;
        this.dispatcherHandler = dispatcherHandler;
        this.pos = 0;
        this.size = filterList.size();
        beforeStopWatch = new StopWatch();
        afterStopWatch = new StopWatch();
        beforeStopWatch.start();
    }

    public void filter(KjjHttpRequest httpRequest, KjjHttpResponse response) throws Throwable {
        if (CollectionUtils.isEmpty(filterList)){
            dispatcherHandler.service(httpRequest,response);
        }
        if (pos < size){
            final CustomFilter customFilter = filterList.get(pos++);
            customFilter.doFilter(this,httpRequest, response);
        }else{
            beforeStopWatch.stop();
            beforeTime.addAndGet(beforeStopWatch.getTotalTimeNanos());
            dispatcherHandler.service(httpRequest,response);
            afterStopWatch.start();
        }
        count.incrementAndGet();
    }

    public void stopAfterWatch(){
        afterStopWatch.stop();
        afterTime.addAndGet(afterStopWatch.getTotalTimeNanos());
    }
}
