package cn.com.duiba.kjy.base.api.enums;

import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * 直播代理人退出公司原因 枚举
 * @author 吴文哲
 * @date 2021/2/25 6:56 下午
 **/
@Getter
public enum AgentQuitCompanyReasonEnums {

    NOT_BELONG(1,"我不属于这家公司"),
    HAVE_NO_MY_TEAM(2,"没有我所在的团队"),
    QUIT_COMPANY(3,"已离职当前公司"),
    DO_NOT_WANT_JOIN_LIVE_ANY_MORE(4,"不想再参与任何直播"),
    OTHER(5,"其它原因"),
    ;

    /**
     * 退出公司原因类型
     */
    private Integer reason;

    /**
     * 退出公司原因描述
     */
    private String desc;

    AgentQuitCompanyReasonEnums(Integer reason,String desc){
        this.reason = reason;
        this.desc = desc;
    }

    private static final Map<Integer, AgentQuitCompanyReasonEnums> ENUM_MAP = new HashMap<>();

    static{
        for(AgentQuitCompanyReasonEnums stateEnum : values()){
            ENUM_MAP.put(stateEnum.getReason(), stateEnum);
        }
    }

    public static AgentQuitCompanyReasonEnums getByType(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }



}
