package cn.com.duiba.kjy.base.api.enums.lottery;

import java.util.HashMap;
import java.util.Map;

/**
 * @author zhanghuifeng
 * date 2021/1/28-16:26
 */
public enum LiveRewardLotteryCollectEnum {

    AGENT_USER_BIND(1,"代理人绑定直播用户"),
    WIN_A_PRIZE(2, "中奖"),
    LOTTERY_CODE(3,"抽奖码"),
    BLACK_LIST(4,"黑名单"),
    UPDATE_DURATION(5,"更新时长"),
    SUBMIT_APPLY(6,"提交报名"),
    USER_PRESENT(7,"用户到场"),
    MANDATE_PHONE(8,"授权手机号"),
    QUIT_COMPANY(9, "退出公司"),
    REMOVE_BLACK_LIST(10, "移除黑名单事件"),
    BE_AGENT(11, "成为代理人事件"),
    AGENT_SEND_LOTTERY_CODE(12, "代理人赠送抽奖码事件"),
    AGENT_CHANGE_TEAM(13,"代理人切换团队事件"),
    UPDATE_BIND_AGENT_TEAM(14,"变更绑定关系代理人和团队事件"),
    ;
    private Integer code;

    private String desc;

    LiveRewardLotteryCollectEnum(Integer code, String desc){
        this.code = code;
        this.desc = desc;
    }

    private static final Map<Integer, LiveRewardLotteryCollectEnum> ENUM_MAP = new HashMap<>();

    static{
        for(LiveRewardLotteryCollectEnum stateEnum : values()){
            ENUM_MAP.put(stateEnum.getCode(), stateEnum);
        }
    }

    public static LiveRewardLotteryCollectEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
