package cn.com.duiba.kjy.base.api.service.datasource;

import cn.com.duibaboot.ext.autoconfigure.core.SpecifiedBeanPostProcessor;
import com.dianping.cat.util.StringUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.sql.DataSource;
import java.util.HashMap;
import java.util.Map;

/**
 * @author dugq
 * @date 2021/4/21 6:23 下午
 */
@Configuration
@ConditionalOnProperty(prefix = "kjj.datasource.moving",name = "enable",havingValue = "true")
@Slf4j
public class DbMovingAutoConfig {

    @Bean
    public MovingDataSourceConfiguration dataSourceConfiguration(){
        return new MovingDataSourceConfiguration();
    }

    @Bean
    public static SpecifiedBeanPostProcessor<DataSource> dbMovingSpecifiedBeanPostProcessor(){
        return new SpecifiedBeanPostProcessor<DataSource>(){
            @Resource
            private ApplicationContext applicationContext;
            @Resource
            private MovingDataSourceConfiguration movingDataSourceConfiguration;

            private final Map<String,String> dataSourceConfig = new HashMap<>();

            private final Map<String,String> redisKeyConfig = new HashMap<>();

            @PostConstruct
            public void init(){
                final Map<String, MovingDbProperties> db = movingDataSourceConfiguration.getDb();
                for (Map.Entry<String, MovingDbProperties> dbPropertiesEntry : db.entrySet()) {
                    final String oldDataSource = dbPropertiesEntry.getKey();
                    final MovingDbProperties newDbConfig = dbPropertiesEntry.getValue();
                    dataSourceConfig.put(oldDataSource,newDbConfig.getNewDataSource());
                    redisKeyConfig.put(oldDataSource,newDbConfig.getRedisKey());
                }
            }

            @Override
            public int getOrder() {
                //在perf 之后执行。保证perf的正常使用
                return Integer.MAX_VALUE;
            }

            @Override
            public Class<DataSource> getBeanType() {
                return DataSource.class;
            }

            @Override
            public DataSource postProcessBeforeInitialization(DataSource bean, String beanName) throws BeansException {
                return bean;
            }

            @Override
            public DataSource postProcessAfterInitialization(DataSource bean, String beanName) throws BeansException {
                final String movingDbNewBean = dataSourceConfig.get(beanName);
                if (StringUtils.isEmpty(movingDbNewBean)){
                    return bean;
                }
                final String redisKey = redisKeyConfig.get(beanName);
                final DataSource newDbBean = applicationContext.getBean(movingDbNewBean,DataSource.class);
                final DbMovingDataSource dbMovingDataSource = new DbMovingDataSource(bean, newDbBean, redisKey);
                dbMovingDataSource.afterPropertiesSet();
//                dbMovingDataSource.setRedisCacheClient(redisCacheClient);
                return dbMovingDataSource;
            }
        };
    }

}
