package cn.com.duiba.kjy.base.api.service.datasource;

import cn.com.duiba.wolf.cache.RedisCacheClient;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;

import javax.sql.DataSource;
import java.util.HashMap;
import java.util.Objects;

/**
 * @author dugq
 * @date 2021/4/21 6:08 下午
 */
public class DbMovingDataSource extends AbstractRoutingDataSource {
    private RedisCacheClient redisCacheClient;
    private final DataSource oldDataSource;
    private final DataSource newDataSource;
    private final String redisKey;
    private static final String OLD_KEY = "old";
    private static final String NEW_KEY = "new";

    public DbMovingDataSource(DataSource oldDataSource, DataSource newDataSource, String redisKey) {
        this.oldDataSource = oldDataSource;
        this.newDataSource = newDataSource;
        this.redisKey = redisKey;
    }

    public void MyAfterPropertiesSet(){
        HashMap<Object, Object> targetDataSource = new HashMap<>();
        targetDataSource.put(OLD_KEY,oldDataSource);
        targetDataSource.put(NEW_KEY,newDataSource);
        setTargetDataSources(targetDataSource);
        setDefaultTargetDataSource(oldDataSource);
        super.afterPropertiesSet();
    }

    @Override
    protected Object determineCurrentLookupKey() {
        try {
            Long flag = redisCacheClient.get(redisKey);
            if (Objects.nonNull(flag) && flag >0){
                return NEW_KEY;
            }
            return OLD_KEY;
        }catch (Exception e){
           logger.error("get key from redis has error!",e);
           return OLD_KEY;
        }
    }

    public void setRedisCacheClient(RedisCacheClient redisCacheClient) {
        this.redisCacheClient = redisCacheClient;
    }
}
