# readme
如果需要数据库迁移时，可选择使用此工具。

原理
-
- 利用springboot的dataSource动态路由类对旧的dataSource进行二次封装，内部包含新旧两个数据源
- 利用redis做实时同步。spring动态路由内部 每次从redis中获取数据库配置的最新值，根据该key的值选择使用新的或旧的数据源


步骤如下
 - 
 - 开启配置：  kjj.datasource.moving.enable=true(application.properties)
 - 配置数据源：将新的数据源配置到spring-datasource-XXX.xml中
 - 指向数据源：kjj.datasource.moving.db.${旧的dataSource}.newDataSource=${新的dataSource}(application.properties)
 - 配置redis开关：kjj.datasource.moving.db.${旧的dataSource}.redisKey=XXXXX
 - 写控制类：写一个TestCtrl，修改redisKey的值为1。redisCacheClient.set(${redisKey},1);
 - 发布系统
 - 调用TestCtrl 开始切换
 - 删掉旧的dataSource，将新的dataSource的beanName改为旧的
 - 关闭配置： kjj.datasource.moving.enable=false(application.properties) 或者直接删除该属性
 - 重新发布系统 并清理掉redisKey的值（为后来人提供良好的环境）。

注意
-
- 此设计中利用了redis作为集群控制器，所以系统必须依赖redis
- redisKey的value为空时，默认为false。redis客户端使用的是redisCacheClient类。


