/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.api.service.datasource;

import cn.com.duiba.kjy.base.api.service.datasource.DbMovingDataSource;
import cn.com.duiba.kjy.base.api.service.datasource.DbMovingSwitchFilter;
import cn.com.duiba.kjy.base.api.service.datasource.MovingDataSourceConfiguration;
import cn.com.duiba.kjy.base.api.service.datasource.MovingDbProperties;
import cn.com.duibaboot.ext.autoconfigure.core.SpecifiedBeanPostProcessor;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.StringRedisTemplate;

@Configuration
@ConditionalOnProperty(prefix="kjj.datasource.moving", name={"enable"}, havingValue="true")
public class DbMovingAutoConfig {
    private static final Logger log = LoggerFactory.getLogger(DbMovingAutoConfig.class);

    @Bean
    public DbMovingSwitchFilter dbMovingSwitchFilter() {
        return new DbMovingSwitchFilter();
    }

    @Bean
    public MovingDataSourceConfiguration dataSourceConfiguration() {
        return new MovingDataSourceConfiguration();
    }

    @Bean
    public static SpecifiedBeanPostProcessor<DataSource> dbMovingSpecifiedBeanPostProcessor() {
        return new SpecifiedBeanPostProcessor<DataSource>(){
            @Resource
            private MovingDataSourceConfiguration movingDataSourceConfiguration;
            @Resource
            private ApplicationContext applicationContext;

            public int getOrder() {
                return Integer.MAX_VALUE;
            }

            public Class<DataSource> getBeanType() {
                return DataSource.class;
            }

            public DataSource postProcessBeforeInitialization(DataSource bean, String beanName) throws BeansException {
                return bean;
            }

            public DataSource postProcessAfterInitialization(DataSource bean, String beanName) throws BeansException {
                if (!this.movingDataSourceConfiguration.getDb().containsKey(beanName)) {
                    return bean;
                }
                MovingDbProperties movingDbProperties = this.movingDataSourceConfiguration.getDb().get(beanName);
                String redisKey = movingDbProperties.getRedisKey();
                String newDataSourceBeanName = movingDbProperties.getNewDataSource();
                DataSource newDbBean = (DataSource)this.applicationContext.getBean(newDataSourceBeanName, DataSource.class);
                DbMovingDataSource dbMovingDataSource = new DbMovingDataSource(bean, newDbBean, redisKey, this::getFlag);
                dbMovingDataSource.afterPropertiesSet();
                return dbMovingDataSource;
            }

            public String getFlag(String redisKey) {
                StringRedisTemplate stringRedisTemplate = (StringRedisTemplate)this.applicationContext.getBean("stringRedisTemplate", StringRedisTemplate.class);
                return (String)stringRedisTemplate.opsForValue().get((Object)redisKey);
            }
        };
    }
}

