/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.customweb.autoconfig;

import cn.com.duiba.kjy.base.customweb.autoconfig.NettyAutoConfiguration;
import cn.com.duiba.kjy.base.customweb.sever.NettyServerConfigurationProperties;
import cn.com.duiba.kjy.base.customweb.web.adaptor.RequestHandlerMappingAdaptor;
import cn.com.duiba.kjy.base.customweb.web.factory.HandlerMappingBeanFactory;
import cn.com.duiba.kjy.base.customweb.web.handler.DispatcherHandler;
import cn.com.duiba.kjy.base.customweb.web.handler.mapping.RequestMappingsRegister;
import cn.com.duiba.kjy.base.customweb.web.handler.mapping.controller.ControllerMappingRegister;
import cn.com.duiba.kjy.base.customweb.web.handler.response.ResponseHandler;
import cn.com.duiba.kjy.base.customweb.web.interceptor.KjjInterceptor;
import cn.com.duiba.kjy.base.customweb.web.processor.parameter.ParameterPostProcessor;
import cn.com.duibaboot.ext.autoconfigure.web.mvc.CustomHttpMessageConverters;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.OrderComparator;
import org.springframework.http.converter.HttpMessageConverter;

@Configuration
@AutoConfigureBefore(value={NettyAutoConfiguration.class})
@ConditionalOnBean(value={NettyServerConfigurationProperties.class})
public class NettyWebAutoConfig {
    @Bean
    public RequestHandlerMappingAdaptor requestHandlerMappingAdaptor() {
        return new RequestHandlerMappingAdaptor();
    }

    @Bean
    public HandlerMappingBeanFactory handlerMappingBeanFactory(ObjectProvider<ParameterPostProcessor> parameterPostProcessors, ObjectProvider<ResponseHandler> responseHandlers) {
        List<ParameterPostProcessor> parameterPostProcessorList = parameterPostProcessors.stream().collect(Collectors.toList());
        List<ResponseHandler> responseHandlerList = responseHandlers.stream().sorted(OrderComparator.INSTANCE).collect(Collectors.toList());
        return new HandlerMappingBeanFactory(parameterPostProcessorList, responseHandlerList);
    }

    @Bean
    public DispatcherHandler dispatcherHandler(ObjectProvider<RequestMappingsRegister> requestMappingsList, ObjectProvider<KjjInterceptor> interceptors) {
        List<RequestMappingsRegister> requestMappingRegisters = requestMappingsList.stream().sorted(OrderComparator.INSTANCE).collect(Collectors.toList());
        Collections.reverse(requestMappingRegisters);
        List<KjjInterceptor> interceptorList = interceptors.stream().sorted(OrderComparator.INSTANCE).collect(Collectors.toList());
        Collections.reverse(interceptorList);
        return new DispatcherHandler(requestMappingRegisters, interceptorList);
    }

    @Bean
    @ConditionalOnMissingBean
    public HttpMessageConverters messageConverters(ObjectProvider<HttpMessageConverter<?>> converters) {
        return new CustomHttpMessageConverters((Collection)converters.orderedStream().collect(Collectors.toList()));
    }

    @Bean
    public ControllerMappingRegister controllerMapping() {
        return new ControllerMappingRegister();
    }
}

