/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.customweb.web.bind.impl;

import cn.com.duiba.kjy.base.customweb.util.ParamReflectUtil;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpRequest;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpResponse;
import cn.com.duiba.kjy.base.customweb.web.bean.ParameterBean;
import cn.com.duiba.kjy.base.customweb.web.bind.ArgsResolver;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValues;
import org.springframework.core.annotation.Order;
import org.springframework.core.convert.ConversionService;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.ResponseBody;

@Order(value=-1)
public class RequestEntityResolver
implements ArgsResolver {
    private static final Logger log = LoggerFactory.getLogger(RequestEntityResolver.class);
    @Resource
    private ConversionService conversionService;

    @Override
    public boolean canRead(Parameter parameter, Class<?> handlerMappingClass, Method handlerMappingMethod) {
        ResponseBody annotation = parameter.getAnnotation(ResponseBody.class);
        if (Objects.nonNull(annotation)) {
            return false;
        }
        RequestHeader requestHeader = parameter.getAnnotation(RequestHeader.class);
        if (Objects.nonNull(requestHeader)) {
            return false;
        }
        return !ParamReflectUtil.isPrimitive(parameter.getType());
    }

    @Override
    public Object doResolver(ParameterBean parameterBean, KjjHttpRequest httpRequest, KjjHttpResponse response) throws Exception {
        Object param = parameterBean.getType().newInstance();
        WebDataBinder webDataBinder = new WebDataBinder(param, parameterBean.getName());
        webDataBinder.setConversionService(this.conversionService);
        MutablePropertyValues pvs = new MutablePropertyValues();
        this.bindMultipart(httpRequest.getParamMap(), pvs);
        webDataBinder.bind((PropertyValues)pvs);
        return param;
    }

    protected void bindMultipart(MultiValueMap<String, String> multipartFiles, MutablePropertyValues mpvs) {
        multipartFiles.forEach((key, values) -> {
            if (values.size() == 1) {
                mpvs.add(key, values.get(0));
            } else {
                mpvs.add(key, values);
            }
        });
    }
}

