/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.customweb.web.factory;

import cn.com.duiba.kjy.base.customweb.web.bean.ParameterBean;
import cn.com.duiba.kjy.base.customweb.web.handler.mapping.controller.ControllerMappingHandler;
import cn.com.duiba.kjy.base.customweb.web.handler.mapping.controller.ControllerMappingHandlerBuilder;
import cn.com.duiba.kjy.base.customweb.web.handler.mapping.controller.ControllerMappingRegister;
import cn.com.duiba.kjy.base.customweb.web.handler.mapping.controller.RequestMappingInfo;
import cn.com.duiba.kjy.base.customweb.web.handler.response.ResponseHandler;
import cn.com.duiba.kjy.base.customweb.web.processor.parameter.ParameterPostProcessor;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.support.ApplicationObjectSupport;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.stereotype.Controller;
import org.springframework.util.ClassUtils;
import org.springframework.web.bind.annotation.RequestMapping;

public class HandlerMappingBeanFactory
extends ApplicationObjectSupport
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(HandlerMappingBeanFactory.class);
    @Resource
    private ControllerMappingRegister controllerMappingRegister;
    private final List<ParameterPostProcessor> parameterPostProcessors;
    private final List<ResponseHandler> responseHandlers;

    public HandlerMappingBeanFactory(List<ParameterPostProcessor> parameterPostProcessors, List<ResponseHandler> responseHandlers) {
        this.parameterPostProcessors = parameterPostProcessors;
        this.responseHandlers = responseHandlers;
    }

    public void builderHandlerMappingAndRegister(Class<?> handlerClass, Method method, String handler, RequestMappingInfo requestMappingInfo) {
        ControllerMappingHandler controllerMappingHandler = this.buildOneHandlerMapping(handlerClass, method, handler, requestMappingInfo);
        this.controllerMappingRegister.registerHandler(controllerMappingHandler);
    }

    private ControllerMappingHandler buildOneHandlerMapping(Class<?> handlerClass, Method handlerMappingMethod, String handler, RequestMappingInfo requestMappingInfo) {
        ControllerMappingHandlerBuilder controllerMappingHandlerBuilder = ControllerMappingHandlerBuilder.create(handlerClass, handlerMappingMethod);
        controllerMappingHandlerBuilder.setRequestMappingInfo(requestMappingInfo);
        Class<?> returnType = handlerMappingMethod.getReturnType();
        controllerMappingHandlerBuilder.setReturnType(returnType);
        controllerMappingHandlerBuilder.setResponseHandler(this.getResponseHandler(handlerMappingMethod, returnType));
        controllerMappingHandlerBuilder.setHandler(handler);
        this.fillParameterList(handlerClass, handlerMappingMethod, controllerMappingHandlerBuilder);
        return controllerMappingHandlerBuilder.build();
    }

    private void fillParameterList(Class<?> handlerClass, Method handlerMappingMethod, ControllerMappingHandlerBuilder controllerMappingHandlerBuilder) {
        Parameter[] parameters = handlerMappingMethod.getParameters();
        ArrayList<ParameterBean> parameterBeans = new ArrayList<ParameterBean>();
        int index = 0;
        for (Parameter parameter : parameters) {
            ParameterBean parameterBean = new ParameterBean();
            Class<?> type = parameter.getType();
            parameterBean.setType(type);
            parameterBean.setName(parameter.getName());
            parameterBean.setPrimitive(type.isPrimitive());
            parameterBean.setMethodParameter(new MethodParameter(handlerMappingMethod, index++));
            this.processorParameter(parameterBean, handlerClass, handlerMappingMethod);
            parameterBeans.add(parameterBean);
        }
        controllerMappingHandlerBuilder.setParamList(parameterBeans);
    }

    private void processorParameter(ParameterBean parameterBean, Class<?> handlerBeanClass, Method method) {
        for (ParameterPostProcessor parameterPostProcessor : this.parameterPostProcessors) {
            parameterPostProcessor.postProcessorParameter(parameterBean, handlerBeanClass, method);
        }
    }

    private ResponseHandler getResponseHandler(Method method, Class<?> returnType) {
        for (ResponseHandler responseHandler : this.responseHandlers) {
            if (!responseHandler.canWrite(method, returnType)) continue;
            return responseHandler;
        }
        throw new UnsupportedOperationException("can not write this type " + returnType.getName() + "in method" + method.getName());
    }

    public void afterPropertiesSet() throws Exception {
        this.init();
    }

    private void init() {
        String[] list;
        for (String beanName : list = this.obtainApplicationContext().getBeanNamesForType(Object.class)) {
            Class beanClass = this.obtainApplicationContext().getType(beanName);
            if (Objects.isNull(beanClass) || !AnnotatedElementUtils.hasAnnotation((AnnotatedElement)beanClass, Controller.class)) continue;
            Class userType = ClassUtils.getUserClass((Class)beanClass);
            MethodIntrospector.selectMethods((Class)userType, method -> Objects.nonNull(AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, RequestMapping.class))).forEach(method -> {
                RequestMapping requestMapping = (RequestMapping)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, RequestMapping.class);
                this.builderHandlerMappingAndRegister(userType, (Method)method, beanName, this.getMappingForMethod(beanClass, requestMapping));
            });
        }
    }

    private RequestMappingInfo getMappingForMethod(Class<?> beanClass, RequestMapping requestMapping) {
        RequestMappingInfo info = this.createRequestMappingInfo(requestMapping);
        if (info != null) {
            RequestMapping ctrlMapping = (RequestMapping)AnnotatedElementUtils.findMergedAnnotation(beanClass, RequestMapping.class);
            RequestMappingInfo typeInfo = this.createRequestMappingInfo(ctrlMapping);
            if (typeInfo != null) {
                info = typeInfo.combine(info);
            }
            info = RequestMappingInfo.paths("/").build().combine(info);
        }
        return info;
    }

    protected RequestMappingInfo createRequestMappingInfo(RequestMapping requestMapping) {
        if (Objects.isNull(requestMapping)) {
            return null;
        }
        return RequestMappingInfo.paths(requestMapping.path()).methods(requestMapping.method()).mappingName(requestMapping.name()).build();
    }
}

