package cn.com.duiba.kjy.base.api.bean.es;

import cn.com.duiba.kjy.base.api.utils.NumberUtil;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author linjianhui
 * @description 分页条件
 * @date 2020-02-07 15:34
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class PageCriteria extends BaseCriteria {
    private static final long serialVersionUID = 2080018870074562788L;
    private Integer pageIndex = 1;
    private Integer pageSize = 50;
    private Object[] searchAfterObjects;

    public int getFrom(){
        return (pageIndex-1) > 0 ? (pageIndex - 1) * pageSize : 0 ;
    }

    public PageCriteria() {
    }

    public void setPageIndex(Integer pageIndex) {
        if(NumberUtil.isNullOrLteZero(pageIndex)){
            this.pageIndex = 1;
        }else{
            this.pageIndex = pageIndex;
        }
    }

    public void setPageSize(Integer pageSize) {
        if(NumberUtil.isNullOrLteZero(pageSize)){
            this.pageSize = 50;
        }else{
            this.pageSize = pageSize;
        }
    }

    public PageCriteria(int pageIndex, int pageSize) {
        this.pageIndex = pageIndex;
        this.pageSize = pageSize;
    }
}
