/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.customweb.util;

import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpRequest;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.util.StopWatch;

public class StopWatchUtil {
    public static Function<KjjHttpRequest, Boolean> filter = request -> false;

    public static StopWatch getAndStart() {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        return stopWatch;
    }

    public static void stop(Key key, KjjHttpRequest request, StopWatch stopWatch) {
        stopWatch.stop();
        if (filter.apply(request).booleanValue()) {
            key.count.incrementAndGet();
            key.time.addAndGet(stopWatch.getLastTaskTimeNanos());
        }
    }

    public static void mark(Key key, KjjHttpRequest request, StopWatch stopWatch) {
        if (filter.apply(request).booleanValue()) {
            stopWatch.stop();
            key.count.incrementAndGet();
            key.time.addAndGet(stopWatch.getTotalTimeNanos());
            stopWatch.start();
        }
    }

    public static List<Detail> getAndClear() {
        return Stream.of(Key.values()).map(key -> {
            Detail detail = new Detail();
            detail.count = key.count.getAndSet(0);
            detail.name = key.name();
            detail.time = key.time.getAndSet(0L);
            if (detail.count <= 0) {
                return null;
            }
            detail.avg = detail.time / (long)detail.count;
            return detail;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static class Detail {
        private String name;
        private int count;
        private long time;
        private long avg;

        public String getName() {
            return this.name;
        }

        public int getCount() {
            return this.count;
        }

        public long getTime() {
            return this.time;
        }

        public long getAvg() {
            return this.avg;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setCount(int count) {
            this.count = count;
        }

        public void setTime(long time) {
            this.time = time;
        }

        public void setAvg(long avg) {
            this.avg = avg;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Detail)) {
                return false;
            }
            Detail other = (Detail)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            if (this.getCount() != other.getCount()) {
                return false;
            }
            if (this.getTime() != other.getTime()) {
                return false;
            }
            return this.getAvg() == other.getAvg();
        }

        protected boolean canEqual(Object other) {
            return other instanceof Detail;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            result = result * 59 + this.getCount();
            long $time = this.getTime();
            result = result * 59 + (int)($time >>> 32 ^ $time);
            long $avg = this.getAvg();
            result = result * 59 + (int)($avg >>> 32 ^ $avg);
            return result;
        }

        public String toString() {
            return "StopWatchUtil.Detail(name=" + this.getName() + ", count=" + this.getCount() + ", time=" + this.getTime() + ", avg=" + this.getAvg() + ")";
        }
    }

    public static enum Key {
        TOTAL,
        FILTER,
        HANDLE,
        INTERCEPTOR_BEFORE,
        ARGS,
        INTERCEPTOR_AFTER,
        CTRL,
        EXT1,
        EXT2,
        EXT3,
        EXT4,
        EXT5,
        EXT6,
        EXT7,
        EXT8,
        EXT9,
        EXT10;

        public AtomicInteger count = new AtomicInteger();
        public AtomicLong time = new AtomicLong();
    }
}

