/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.customweb.web.filter;

import cn.com.duiba.kjy.base.customweb.util.StopWatchUtil;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpRequest;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpResponse;
import cn.com.duiba.kjy.base.customweb.web.filter.CustomFilter;
import cn.com.duiba.kjy.base.customweb.web.filter.CustomFilterChain;
import cn.com.duiba.kjy.base.customweb.web.handler.mapping.controller.ControllerMappingRegister;
import com.alibaba.fastjson.JSON;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.http.entity.ContentType;
import org.springframework.boot.actuate.beans.BeansEndpoint;
import org.springframework.boot.actuate.management.ThreadDumpEndpoint;
import org.springframework.cloud.endpoint.RefreshEndpoint;
import org.springframework.context.support.ApplicationObjectSupport;

public class ActuateFilter
extends ApplicationObjectSupport
implements CustomFilter {
    private final BeansEndpoint beansEndpoint;
    @Resource
    private ControllerMappingRegister controllerMappingRegister;
    private ThreadDumpEndpoint threadDumpEndpoint;
    private RefreshEndpoint refreshEndpoint;

    public ActuateFilter(BeansEndpoint beansEndpoint, ThreadDumpEndpoint threadDumpEndpoint, RefreshEndpoint refreshEndpoint) {
        this.beansEndpoint = beansEndpoint;
        this.threadDumpEndpoint = threadDumpEndpoint;
        this.refreshEndpoint = refreshEndpoint;
    }

    @Override
    public void doFilter(CustomFilterChain customFilterChain, KjjHttpRequest httpRequest, KjjHttpResponse response) throws Throwable {
        String path = httpRequest.getUri().getPath();
        if (!path.startsWith("/actuator")) {
            customFilterChain.filter(httpRequest, response);
            return;
        }
        switch (path) {
            case "/actuator/beans": {
                response.setContentType(ContentType.APPLICATION_JSON.getMimeType());
                if (Objects.nonNull(this.beansEndpoint)) {
                    response.write(JSON.toJSONString((Object)this.beansEndpoint.beans()));
                } else {
                    response.write("no auth!");
                }
                response.flushAndClose();
                return;
            }
            case "/actuator/mappings": {
                response.write(JSON.toJSONString(this.controllerMappingRegister.getHandlerList()));
                response.flushAndClose();
                return;
            }
            case "/actuator/threaddump": {
                if (Objects.nonNull(this.threadDumpEndpoint)) {
                    response.write(JSON.toJSONString((Object)this.threadDumpEndpoint.threadDump()));
                    response.flushAndClose();
                    return;
                }
            }
            case "/actuator/evn": {
                if (Objects.nonNull(this.threadDumpEndpoint)) {
                    response.write(JSON.toJSONString((Object)this.threadDumpEndpoint.threadDump()));
                    response.flushAndClose();
                    return;
                }
            }
            case "/actuator/times": {
                response.write(JSON.toJSONString(StopWatchUtil.getAndClear()));
                response.flushAndClose();
                return;
            }
            case "/actuator/refresh": {
                response.write(JSON.toJSONString((Object)this.refreshEndpoint.refresh()));
                response.flushAndClose();
                return;
            }
        }
        customFilterChain.filter(httpRequest, response);
    }
}

