/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.customweb.sever;

import cn.com.duiba.kjy.base.customweb.util.StopWatchUtil;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpRequest;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpResponse;
import cn.com.duiba.kjy.base.customweb.web.handler.DispatcherHandler;
import cn.com.duiba.kjy.base.customweb.web.handler.exception.ExceptionChain;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StopWatch;

public class KjjChannelInboundHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private static final Logger log = LoggerFactory.getLogger(KjjChannelInboundHandler.class);
    private final DispatcherHandler dispatcherHandler;
    private final ExceptionChain exceptionChain;

    public KjjChannelInboundHandler(DispatcherHandler dispatcherHandler, ExceptionChain exceptionChain) {
        this.dispatcherHandler = dispatcherHandler;
        this.exceptionChain = exceptionChain;
    }

    protected void channelRead0(ChannelHandlerContext ctx, FullHttpRequest httpRequest) throws Exception {
        this.doReader(ctx, httpRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doReader(ChannelHandlerContext ctx, FullHttpRequest httpRequest) {
        StopWatch stopWatch = StopWatchUtil.getAndStart();
        KjjHttpRequest request = new KjjHttpRequest(ctx, httpRequest);
        KjjHttpResponse response = new KjjHttpResponse(ctx, httpRequest);
        try {
            this.dispatcherHandler.handler(request, response);
        }
        catch (Throwable e) {
            this.exceptionChain.handlerException(request, response, e);
        }
        finally {
            try {
                if (request.isSync() && !response.isClosed()) {
                    log.error("request where uri = {} is not closed right!", (Object)httpRequest.uri());
                    response.setContentType(ContentType.TEXT_PLAIN.getMimeType());
                    response.setStatus(HttpResponseStatus.SERVICE_UNAVAILABLE);
                    response.write("NO RESPONSE");
                    response.flushAndClose();
                }
            }
            catch (Exception e) {
                log.error("request disaster tolerance has error! this must be joker!", (Throwable)e);
            }
            StopWatchUtil.stop(StopWatchUtil.Key.TOTAL, request, stopWatch);
        }
    }

    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        super.channelRegistered(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        log.error("channel has exception = {}", (Object)ctx.channel(), (Object)cause);
        ctx.close();
    }
}

