/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.api.queue;

import cn.com.duiba.kjy.base.api.queue.AbstractQueueService;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAsyncQueueService<T>
extends AbstractQueueService<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractAsyncQueueService.class);
    @Resource
    private ExecutorService executorService;

    public AbstractAsyncQueueService(int capacity, int batchSize, int maxWaitSize, int maxWaitTimeMillis) {
        super(capacity, batchSize, maxWaitSize, maxWaitTimeMillis);
    }

    @Override
    protected void batchConsume(List<T> list) {
        this.executorService.execute(() -> {
            try {
                this.batchConsumeMsg(list);
            }
            catch (Exception e) {
                log.error("batchConsumeMsg, class={}, e:", (Object)this.getClass().getName(), (Object)e);
            }
        });
    }
}

