/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.customweb.ribbon;

import cn.com.duiba.boot.netflix.ribbon.RibbonServerListFilter;
import cn.com.duiba.boot.utils.MainApplicationContextHolder;
import cn.com.duiba.kjy.base.customweb.sever.KjjAnnotationConfigApplicationContext;
import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.ribbon.loadbalancer.WeightedLeastConnectionRule;
import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.ribbon.loadbalancer.WeightedRandomRule;
import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.ribbon.loadbalancer.WeightedRoundRobinRule;
import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.AbstractLoadBalancerRule;
import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.loadbalancer.IRule;
import com.netflix.loadbalancer.Server;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;

public class RuntimeRule
extends AbstractLoadBalancerRule
implements ApplicationListener<EnvironmentChangeEvent> {
    private static Logger log = LoggerFactory.getLogger(cn.com.duibaboot.ext.autoconfigure.cloud.netflix.ribbon.loadbalancer.RuntimeRule.class);
    private static final String RIBBON_LOADBALANCE_TYPE_KEY = "duiba.ribbon.loadbalance.type";
    private volatile IRule delegate;
    private IClientConfig clientConfig;
    private List<RibbonServerListFilter> ribbonServerListFilters = Collections.emptyList();
    @Resource
    public ApplicationContext applicationContext;

    @Autowired(required=false)
    public void setRibbonServerListFilters(List<RibbonServerListFilter> ribbonServerListFilters) {
        if (ribbonServerListFilters != null) {
            this.ribbonServerListFilters = ribbonServerListFilters;
        }
    }

    @PostConstruct
    public void init() {
        ApplicationContext tempContext = this.applicationContext;
        while (!(tempContext instanceof KjjAnnotationConfigApplicationContext) && tempContext.getParent() != null) {
            tempContext = tempContext.getParent();
        }
        if (tempContext instanceof KjjAnnotationConfigApplicationContext) {
            this.applicationContext = tempContext;
        } else {
            log.warn("[NOTIFYME] can not find valid applicationContext, will use weightedRoundRobin.");
        }
        String loadBalanceType = this.applicationContext.getEnvironment().getProperty(RIBBON_LOADBALANCE_TYPE_KEY, "weightedRoundRobin");
        Object temp = "weightedRoundRobin".equals(loadBalanceType) ? new WeightedRoundRobinRule(this.getLoadBalancer(), this.ribbonServerListFilters) : ("weightedRandom".equals(loadBalanceType) ? new WeightedRandomRule(this.getLoadBalancer(), this.ribbonServerListFilters) : ("weightedLeastConnection".equals(loadBalanceType) || "leastactive".equals(loadBalanceType) ? new WeightedLeastConnectionRule(this.getLoadBalancer(), this.ribbonServerListFilters) : new WeightedRoundRobinRule(this.getLoadBalancer(), this.ribbonServerListFilters)));
        temp.initWithNiwsConfig(this.clientConfig);
        this.delegate = temp;
        if (this.applicationContext instanceof ConfigurableApplicationContext) {
            ((ConfigurableApplicationContext)tempContext).addApplicationListener((ApplicationListener)this);
        } else {
            log.warn("Not found ConfigurableWebApplicationContext, {} will no be refreshable", (Object)RIBBON_LOADBALANCE_TYPE_KEY);
        }
    }

    public void onApplicationEvent(EnvironmentChangeEvent event) {
        if (event.getKeys() == null || !event.getKeys().contains(RIBBON_LOADBALANCE_TYPE_KEY)) {
            return;
        }
        this.init();
    }

    public Server choose(Object key) {
        Server server = this.delegate.choose(key);
        return server;
    }

    public void initWithNiwsConfig(IClientConfig clientConfig) {
        this.clientConfig = clientConfig;
    }

    public void setLoadBalancer(ILoadBalancer lb) {
        super.setLoadBalancer(lb);
        if (this.delegate == null) {
            this.applicationContext = MainApplicationContextHolder.getApplicationContext();
            if (this.applicationContext == null) {
                log.warn("[NOTIFYME]applicationContext is null, will not be here");
                return;
            }
            this.ribbonServerListFilters = new ArrayList(MainApplicationContextHolder.getApplicationContext().getBeansOfType(RibbonServerListFilter.class).values());
            this.init();
        }
        this.delegate.setLoadBalancer(lb);
    }
}

