/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.reactive.util;

import java.net.InetSocketAddress;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpCookie;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.server.ServerRequest;

public final class ReactRequestTool {
    private static final String UNKNOWN = "unknown";
    private static final String IPHONE = "iphone";
    private static final String ANDROID = "android";
    private static final String IOS = "ios";
    private static final String IPAD = "ipad";
    private static final String MACINTOSH = "macintosh";
    private static final String LINUX = "linux";
    private static final String WINDOWS = "windows";
    private static Map<String, String> osMap = new LinkedHashMap<String, String>();

    private ReactRequestTool() {
    }

    public static String getUserAgent(ServerRequest req) {
        if (req != null) {
            return req.headers().firstHeader("User-Agent");
        }
        return null;
    }

    public static String getUserAgent(ServerHttpRequest req) {
        if (req != null) {
            return req.getHeaders().getFirst("User-Agent");
        }
        return null;
    }

    public static String getFullRequestUrl(ServerRequest request) {
        String url = request.uri().getPath();
        String queryString = request.uri().getQuery();
        if (queryString == null) {
            return url;
        }
        return url + "?" + queryString;
    }

    public static String getFullRequestUrl(ServerHttpRequest request) {
        String url = request.getURI().getPath();
        String queryString = request.getURI().getQuery();
        if (queryString == null) {
            return url;
        }
        return url + "?" + queryString;
    }

    public static String getIpAddr(ServerRequest request) {
        String[] ips;
        int size;
        String ip = request.headers().firstHeader("x-forwarded-for");
        if (ip != null && ip.trim().length() > 0 && (size = (ips = ip.trim().split(",")).length) > 0) {
            ip = ips[0].trim();
        }
        if (ReactRequestTool.isInvalidIp(ip)) {
            ip = request.headers().firstHeader("X-Real-IP");
        }
        if (ReactRequestTool.isInvalidIp(ip)) {
            ip = request.headers().firstHeader("Proxy-Client-IP");
        }
        if (ReactRequestTool.isInvalidIp(ip)) {
            ip = request.headers().firstHeader("WL-Proxy-Client-IP");
        }
        if (ReactRequestTool.isInvalidIp(ip)) {
            ip = request.headers().firstHeader("Cdn-Src-Ip");
        }
        if (ReactRequestTool.isInvalidIp(ip)) {
            ip = request.remoteAddress().map(InetSocketAddress::getHostName).orElse(null);
        }
        if (ip != null && ip.startsWith("0:0:0:0")) {
            ip = "127.0.0.1";
        }
        return ip;
    }

    public static String getIpAddr(ServerHttpRequest request) {
        String[] ips;
        int size;
        String ip = request.getHeaders().getFirst("x-forwarded-for");
        if (ip != null && ip.trim().length() > 0 && (size = (ips = ip.trim().split(",")).length) > 0) {
            ip = ips[0].trim();
        }
        if (ReactRequestTool.isInvalidIp(ip)) {
            ip = request.getHeaders().getFirst("X-Real-IP");
        }
        if (ReactRequestTool.isInvalidIp(ip)) {
            ip = request.getHeaders().getFirst("Proxy-Client-IP");
        }
        if (ReactRequestTool.isInvalidIp(ip)) {
            ip = request.getHeaders().getFirst("WL-Proxy-Client-IP");
        }
        if (ReactRequestTool.isInvalidIp(ip)) {
            ip = request.getHeaders().getFirst("Cdn-Src-Ip");
        }
        if (ReactRequestTool.isInvalidIp(ip)) {
            String string = ip = Objects.isNull(request.getRemoteAddress()) ? null : request.getRemoteAddress().getHostName();
        }
        if (ip != null && ip.startsWith("0:0:0:0")) {
            ip = "127.0.0.1";
        }
        if (StringUtils.equals((CharSequence)"localhost", (CharSequence)ip)) {
            ip = "127.0.0.1";
        }
        return ip;
    }

    private static boolean isInvalidIp(String ip) {
        return ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip);
    }

    public static boolean isProxy(ServerRequest request) {
        String[] ips;
        long sizeOfForwardFor;
        String httpVia = request.headers().firstHeader("HTTP_VIA");
        if (httpVia != null && !"".equals(httpVia)) {
            return true;
        }
        String xForwardedFor = request.headers().firstHeader("x-forwarded-for");
        return xForwardedFor != null && xForwardedFor.trim().length() > 0 && (sizeOfForwardFor = (long)(ips = xForwardedFor.trim().split(",")).length) > 1L;
    }

    public static String getOS(ServerHttpRequest request) {
        String ua = ReactRequestTool.getUserAgent(request);
        return ReactRequestTool.getOS(ua);
    }

    public static String getOS(ServerRequest request) {
        String ua = ReactRequestTool.getUserAgent(request);
        return ReactRequestTool.getOS(ua);
    }

    public static String getOS(String ua) {
        if (ua == null) {
            return UNKNOWN;
        }
        String ua1 = ua.toLowerCase();
        for (Map.Entry<String, String> entry : osMap.entrySet()) {
            if (!ua1.contains(entry.getKey())) continue;
            return entry.getValue();
        }
        return UNKNOWN;
    }

    public static String getSimpleOs(ServerHttpRequest request) {
        String ua = ReactRequestTool.getUserAgent(request);
        if (ua != null) {
            String ua1 = ua.toLowerCase();
            if (ua1.contains(IPAD) || ua1.contains(IPHONE) || ua1.contains(MACINTOSH)) {
                return IOS;
            }
            if (ua1.contains(ANDROID)) {
                return ANDROID;
            }
        }
        return UNKNOWN;
    }

    public static String getSimpleOs(ServerRequest request) {
        String ua = ReactRequestTool.getUserAgent(request);
        if (ua != null) {
            String ua1 = ua.toLowerCase();
            if (ua1.contains(IPAD) || ua1.contains(IPHONE) || ua1.contains(MACINTOSH)) {
                return IOS;
            }
            if (ua1.contains(ANDROID)) {
                return ANDROID;
            }
        }
        return UNKNOWN;
    }

    public static String getOSNew(ServerRequest request) {
        String ua = ReactRequestTool.getUserAgent(request);
        return ReactRequestTool.getOSNew(ua);
    }

    public static String getOSNew(String ua) {
        if (ua == null) {
            return "6";
        }
        String ua1 = ua.toLowerCase();
        if (ua1.contains(IPAD)) {
            return "4";
        }
        if (ua1.contains(IPHONE)) {
            return "1";
        }
        if (ua1.contains(ANDROID)) {
            return "0";
        }
        if (ua1.contains(LINUX)) {
            return "5";
        }
        if (ua1.contains(WINDOWS)) {
            return "2";
        }
        if (ua1.contains(MACINTOSH)) {
            return "3";
        }
        if (ua1.contains(IOS)) {
            return "6";
        }
        return "6";
    }

    public static boolean isLocalRequest(ServerRequest request) {
        String ip = ReactRequestTool.getIpAddr(request);
        return ip.startsWith("127.0.0.1") || ip.startsWith("0:0:0:0");
    }

    public static String getCookie(ServerRequest request, String name) {
        MultiValueMap cookies = request.cookies();
        HttpCookie cookiesFirst = (HttpCookie)cookies.getFirst((Object)name);
        if (Objects.isNull(cookiesFirst)) {
            return null;
        }
        return cookiesFirst.getValue();
    }

    public static String getCookie(ServerHttpRequest request, String name) {
        MultiValueMap cookies = request.getCookies();
        HttpCookie cookiesFirst = (HttpCookie)cookies.getFirst((Object)name);
        if (Objects.isNull(cookiesFirst)) {
            return null;
        }
        return cookiesFirst.getValue();
    }

    public static boolean isIos(ServerRequest request) {
        if (request == null) {
            return false;
        }
        String ua = ReactRequestTool.getUserAgent(request);
        if (ua == null) {
            return false;
        }
        return (ua = ua.toLowerCase()).contains(IPHONE) || ua.contains(IPAD) || ua.contains(MACINTOSH);
    }

    public static boolean isAndroid(ServerRequest request) {
        if (request == null) {
            return false;
        }
        String ua = ReactRequestTool.getUserAgent(request);
        if (ua == null) {
            return false;
        }
        ua = ua.toLowerCase();
        return ua.contains(ANDROID);
    }

    public static String getReferer(ServerRequest request) {
        if (request == null) {
            return null;
        }
        return request.headers().firstHeader("referer");
    }

    public static String getReferer(ServerHttpRequest request) {
        if (request == null) {
            return null;
        }
        return request.getHeaders().getFirst("referer");
    }

    static {
        osMap.put(IPHONE, "iPhone");
        osMap.put(ANDROID, "Android");
        osMap.put(IPAD, "iPad");
        osMap.put(MACINTOSH, "Mac");
        osMap.put(WINDOWS, "Windows");
        osMap.put(LINUX, "Linux");
    }
}

