package cn.com.duiba.kjy.base.customweb.web.filter;

import cn.com.duiba.boot.utils.NetUtils;
import cn.com.duiba.boot.utils.SpringEnvironmentUtils;
import cn.com.duiba.kjy.base.customweb.util.ServiceGroupUtils;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpRequest;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpResponse;
import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.feign.DuibaFeignProperties;
import cn.com.duibaboot.ext.autoconfigure.grouping.RocketMqMessageListenerPostProcessor4Group;
import cn.com.duibaboot.ext.autoconfigure.grouping.ServiceGroupContext;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.ApplicationContext;

import javax.annotation.Resource;
import java.io.IOException;

/**
 * @author dugq
 * @date 2021/10/14 7:37 下午
 */
public class ServiceGroupFilter implements CustomFilter{
    public static final String ROCKETMQ_MSG_DISPATCH_PATH = "/bootext/serviceGroup/rocketmqMsgDispatch";

    @Resource
    private ApplicationContext applicationContext;



    private void handleRocketMQMessage(KjjHttpRequest req, KjjHttpResponse resp) throws IOException {
        byte[] bs = req.getRequestBody();
        RocketMqMessageListenerPostProcessor4Group.RocketMqRunInOtherNodeTask task =
                DuibaFeignProperties.DuibaFeignSerialization.HESSIAN2.deserialize(bs);
        task.setApplicationContext(applicationContext);

        Object obj = task.call();

        byte[] returnBs = DuibaFeignProperties.DuibaFeignSerialization.HESSIAN2.serialize(obj);
        resp.getContent().writeBytes(returnBs);
    }

    @Override
    public void doFilter(CustomFilterChain chain, KjjHttpRequest request, KjjHttpResponse response) throws Throwable {
        String groupKey = ServiceGroupUtils.getDuibaServiceGroupKey( request);
        if(groupKey == null && SpringEnvironmentUtils.isDevEnv()){//开发环境获取ip作为服务分组id，以实现优先调用开发者本地服务的逻辑,以提升开发效率
            String ip = request.getIpAddr();
            if(ip.equals("127.0.0.1")){
                ip = NetUtils.getLocalIp();
            }
            groupKey = ServiceGroupUtils.DUIBA_SERVICE_GROUP_IP_PREFIX + ip;
        }

        if (StringUtils.isNotBlank(groupKey)) {
            ServiceGroupContext.setGroupKey(groupKey);
        }

        String uri = request.getRequestURI();
        if(ROCKETMQ_MSG_DISPATCH_PATH.equals(uri)) {
            handleRocketMQMessage(request,  response);
            return;
        }

        try {
            chain.filter(request, response);
        } finally {
            ServiceGroupContext.removeGroupKey();
        }
    }
}
