package cn.com.duibaboot.kjj.oss.conf;

import com.aliyun.oss.ClientConfiguration;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.common.auth.DefaultCredentialProvider;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.util.LinkedHashMap;
import java.util.Map;

/**
 * @author dugq
 * @date 2021/7/21 2:22 下午
 *
 *
 */
@ConfigurationProperties(prefix = OssProps.prefix)
@Data
@Slf4j
public class OssProps {

    public static final String prefix = "apollo";

    private Map<String, OssClientProps> oss = new LinkedHashMap<>();

    @Data
    static class OssClientProps {
        //账号ID
        private String accessId;
        //账号密钥
        private String accessKey;
        //oss端点 https开头，以/结尾
        private String endPoint;
        //分区名
        private String bucketName;
        //分区加速访问域名
        private String CDNDomain;
        //上传下载内部socket参数
        private Integer connectTimeOut=30000;
        //上传下载内部socket参数
        private Integer maxErrorRetry=1;
        //标记该bucket是否是私有的
        private boolean privateBucket;

        public OSSClient newInstance(){
            try {
                final DefaultCredentialProvider credentialProvider = new DefaultCredentialProvider(accessId, accessKey);
                ClientConfiguration clientConfiguration = new ClientConfiguration();
                clientConfiguration.setConnectionTimeout(connectTimeOut);
                clientConfiguration.setMaxErrorRetry(maxErrorRetry);
                return new OSSClient(endPoint, credentialProvider, clientConfiguration);
            }catch (Exception e){
                log.error("初始化ossClient发生异常：oss props={}",this,e);
                return null;
            }
        }
    }


}
