package cn.com.duiba.kjy.base.customweb.web.filter;

import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpRequest;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpResponse;
import cn.com.duibaboot.ext.autoconfigure.web.ServerStatusHolder;
import io.netty.handler.codec.http.HttpResponseStatus;

import java.util.Objects;

/**
 * @author dugq
 * @date 2021/3/25 4:50 下午
 */
public class MonitorFilter implements CustomFilter{
    @Override
    public void doFilter(CustomFilterChain customFilterChain, KjjHttpRequest httpRequest, KjjHttpResponse response) throws Throwable {
        final String uri = httpRequest.uri();
        if (uri.startsWith("/monitor")){
            doMonitor(httpRequest, response, uri);
        }else{
            customFilterChain.filter(httpRequest,response);
        }
    }

    private void doMonitor(KjjHttpRequest httpRequest, KjjHttpResponse response, String uri) {
        //当前请求不打印access日志
        httpRequest.addAttribute(KjjAccessLogFilter.DONT_WRITE_CURRENT_ACCESSLOG,true);
        if(Objects.equals(uri, "/monitor/check")){//检查服务器状态，OK表示正常，INVALID表示服务不可用
            if(!ServerStatusHolder.isInService()){
                response.setStatus(HttpResponseStatus.SERVICE_UNAVAILABLE);
            }
            response.write(ServerStatusHolder.isInService() ? "OK" : "INVALID");
            response.flushAndClose();
        }else if(Objects.equals(uri, "/monitor/stop")){//让check接口返回INVALID
            if(!isLocal(httpRequest)){
                response.write("NO PERMISSION");
                response.flushAndClose();
                return;
            }
            ServerStatusHolder.setInService(false);
            response.write("OK");
            response.flushAndClose();
        }else if(Objects.equals(uri, "/monitor/start")){// 让check接口返回OK
            if(!isLocal(httpRequest)){
                response.write("NO PERMISSION");
                response.flushAndClose();
                return;
            }
            ServerStatusHolder.setInService(true);
            response.write("OK");
            response.flushAndClose();
        }else{
            response.write("NO PERMISSION");
            response.flushAndClose();
        }
    }

    private boolean isLocal(KjjHttpRequest httpRequest) {
        return httpRequest.getIpAddr().equals("127.0.0.1") && httpRequest.getIpAddr().equals("0:0:0:0");
    }
}
