package cn.com.duiba.kjy.base.reactive.fitler;

import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

import java.net.URI;

/**
 * @author dugq
 * @date 2021/3/11 4:11 下午
 */
@Order(Ordered.HIGHEST_PRECEDENCE)
public class MonitorWebFilter implements WebFilter {
    @Override
    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        final URI uri = exchange.getRequest().getURI();
        final String requestPath = uri.getPath();
        if(requestPath.equals("/monitor/check")){//检查服务器状态，OK表示正常，INVALID表示服务不可用
            return writeMsg(exchange,"ok");
        }else if(requestPath.equals("/monitor/stop")){//让check接口返回INVALID
            return writeMsg(exchange,"ok");
        }else if(requestPath.equals("/monitor/start")){// 让check接口返回OK
            return writeMsg(exchange,"ok");
        }else{
            return chain.filter(exchange);
        }
    }

    private Mono<Void> writeMsg(ServerWebExchange exchange,String msg) {
        final ServerHttpResponse response = exchange.getResponse();
        DataBuffer buffer = response.bufferFactory().wrap(msg.getBytes());
        final Mono<DataBuffer> just = Mono.just(buffer);
        return response.writeWith(just);
    }
}
