package cn.com.duibaboot.kjj.oss.template;

import lombok.Setter;
import org.apache.commons.lang.StringUtils;

/**
 * @author dugq
 * @date 2021/7/21 4:02 下午
 */
@Setter
public class PublicBucketOssTemplate extends AbstractOssTemplate{

    @Override
    public String getUrl(String key) {
        //兼容没有配置的场景
        if (StringUtils.isBlank(cdnDomain)){
            return getBucketUri()+key;
        }
        StringBuilder sb = new StringBuilder();
        //兼容没有加协议的场景
        if (!cdnDomain.startsWith("http")){
            sb.append("https:");
            //兼容没有加协议，但是加了//的场景
            if (!cdnDomain.startsWith("//")){
                sb.append("//");
            }
        }
        sb.append(cdnDomain);
        if (!cdnDomain.endsWith("/")){
            sb.append("/");
        }
      return  sb.append(key).toString();
    }
}
