package cn.com.duiba.kjy.base.customweb.web.processor.parameter.impl;


import cn.com.duiba.kjy.base.customweb.web.bean.ParameterBean;
import cn.com.duiba.kjy.base.customweb.web.bind.ArgsResolver;
import cn.com.duiba.kjy.base.customweb.web.processor.parameter.ParameterPostProcessor;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.List;

/**
 * @author dugq
 * @date 2021/3/24 11:21 下午
 */
public class ParamResolverProcessor implements ParameterPostProcessor {
    private final List<ArgsResolver> argsResolvers;

    public ParamResolverProcessor(List<ArgsResolver> argsResolvers) {
        this.argsResolvers = argsResolvers;
    }


    private ArgsResolver getMatchedResolver(Parameter parameter, Class<?> handlerMappingClass, Method handlerMappingMethod){
        for (ArgsResolver argsResolver : argsResolvers) {
            if (argsResolver.canRead(parameter,handlerMappingClass,handlerMappingMethod)){
                return argsResolver;
            }
        }
        throw new RuntimeException("can not find resolver for parameter ["+parameter.getName()+"] of method ["+handlerMappingMethod.getName()+"] in class ["+handlerMappingClass.getName()+"]");
    }


    @Override
    public void postProcessorParameter(ParameterBean parameterBean, Class<?> handlerBeanClass, Method method) {
        final ArgsResolver matchedResolver = getMatchedResolver(parameterBean.getMethodParameter().getParameter(), handlerBeanClass, method);
        matchedResolver.prepareResolver(parameterBean,handlerBeanClass,method);
        parameterBean.setArgsResolver(matchedResolver);
    }
}
