/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.api.utils.autotest;

import cn.com.duiba.boot.utils.SpringEnvironmentUtils;
import cn.com.duiba.kjy.base.api.enums.DeletedEnum;
import cn.com.duiba.user.service.api.dto.user.TestUserDto;
import cn.com.duiba.user.service.api.dto.user.UserExtDto;
import cn.com.duiba.user.service.api.remoteservice.user.RemoteTestUserService;
import cn.com.duiba.user.service.api.remoteservice.user.RemoteUserExtApiService;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class AutoTestUtil {
    @Resource
    private RemoteTestUserService remoteTestUserService;
    @Resource
    private RemoteUserExtApiService remoteUserExtApiService;

    public boolean isAutoTestUser(Long userId) {
        if (Objects.isNull(userId) || !SpringEnvironmentUtils.isTestEnv()) {
            return false;
        }
        TestUserDto testUserDto = this.remoteTestUserService.findByUserId(userId);
        return Objects.nonNull(testUserDto) && Objects.equals(DeletedEnum.NON_DELETED.getCode(), testUserDto.getDeleted());
    }

    public boolean isAutoTestUser(String openId) {
        if (StringUtils.isBlank((CharSequence)openId) || !SpringEnvironmentUtils.isTestEnv()) {
            return false;
        }
        UserExtDto extDto = this.remoteUserExtApiService.findByOpenId(openId);
        if (Objects.isNull(extDto)) {
            return false;
        }
        TestUserDto testUserDto = this.remoteTestUserService.findByUserId(extDto.getUserId());
        return Objects.nonNull(testUserDto) && Objects.equals(DeletedEnum.NON_DELETED.getCode(), testUserDto.getDeleted());
    }
}

