package cn.com.duiba.kjy.base.api.utils;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;

import java.io.IOException;
import java.util.Objects;

/**
 * Created by dugq on 2019-05-05.
 *  使用jackson序列化ID。
 *  eg：
 *
 *  @JsonSerialize(using = IdBase64Serializable.class)
 *  private Long id;
 */
public class IdBase64Serializable extends JsonSerializer<Long> {

    @Override
    public void serialize(Long value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        if(Objects.nonNull(value)){
            gen.writeString(IdMakeUtil.encodingId(value));
        }
    }
}
