package cn.com.duiba.kjy.base.customweb.web.interceptor;


import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpRequest;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpResponse;

/**
 * @author dugq
 * @date 2021/3/25 2:20 下午
 */
public interface KjjInterceptor {

    /**
     * @param request KjjHttpRequest
     * @param response KjjHttpResponse
     * @param handler  for the rest api it must be {@link cn.com.duiba.kjy.base.customweb.web.handler.mapping.controller.ControllerMappingHandler}
     * @return true: every thing is ok !
     *         false: it is the end of this request, so that you must make response content by your self!
     */
    boolean applyPreHandle(KjjHttpRequest request, KjjHttpResponse response, Object handler);

    /**
     * 请求后置拦截器。
     * 在这里，不应该有复杂逻辑，以免使得原本已经成功了的请求，在这里异常结束
     * @param request KjjHttpRequest
     * @param response KjjHttpResponse
     * @param handler for the rest api it must be {@link cn.com.duiba.kjy.base.customweb.web.handler.mapping.controller.ControllerMappingHandler}
     * @param result the response content of rest api! for safe ,you should not change it.
     */
    void applyPostHandle(KjjHttpRequest request, KjjHttpResponse response, Object handler, Object result);

    /**
     * 当发生异常时也会执行的方法，
     * 在这里，不应该有复杂逻辑，以免使得原本已经成功了的请求，在这里异常结束
     *  @param request KjjHttpRequest
     * @param response KjjHttpResponse
     * @param handler for the rest api it must be {@link cn.com.duiba.kjy.base.customweb.web.handler.mapping.controller.ControllerMappingHandler}
     * @param e it will be null if every thing be ok!
     */
    default void afterCompletion(KjjHttpRequest request, KjjHttpResponse response, Object handler, Exception e){

    }
}
