package cn.com.duiba.kjy.base.customweb.web.processor.parameter.impl;

import cn.com.duiba.kjy.base.customweb.web.bean.ParameterBean;
import cn.com.duiba.kjy.base.customweb.web.processor.parameter.ParameterPostProcessor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.RequestParam;

import java.lang.reflect.Method;
import java.util.Objects;

/**
 * @author dugq
 * @date 2021/3/24 11:10 下午
 */
public class RequestParamAnnotationProcessor implements ParameterPostProcessor {

    @Override
    public void postProcessorParameter(ParameterBean parameterBean, Class<?> handlerBeanClass, Method method) {
        final RequestParam annotation = parameterBean.getMethodParameter().getParameterAnnotation(RequestParam.class);
        if (Objects.isNull(annotation)){
            return;
        }
        final String s = annotation.defaultValue();
        final String name = annotation.value();
        if (StringUtils.isNoneBlank(name)){
            parameterBean.setName(name);
        }
        if (StringUtils.isNoneBlank(s)){
            parameterBean.setDefaultValue(s);
        }
    }
}
