/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.api.listener;

import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.ApplicationObjectSupport;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Configuration
@ConditionalOnProperty(name={"kjj.url.prefix"})
public class UrlListener
extends ApplicationObjectSupport
implements InitializingBean,
EnvironmentAware {
    private static final Logger log = LoggerFactory.getLogger(UrlListener.class);
    private Environment environment;

    public void afterPropertiesSet() throws Exception {
        String urlPrefix = this.getUrlPrefix(this.environment);
        if (StringUtils.isBlank((CharSequence)urlPrefix)) {
            return;
        }
        this.doValidator(urlPrefix, RestController.class);
        this.doValidator(urlPrefix, Controller.class);
    }

    private void doValidator(String urlPrefix, Class<? extends Annotation> annotationType) {
        Map restCtrlBean = this.obtainApplicationContext().getBeansWithAnnotation(annotationType);
        block0: for (Object bean : restCtrlBean.values()) {
            RequestMapping annotation = bean.getClass().getAnnotation(RequestMapping.class);
            if (Objects.isNull(annotation)) {
                log.error("bean name = {} has no requestMapping it is not standard.please make url start with {}", (Object)bean.getClass().getName(), (Object)urlPrefix);
                continue;
            }
            Object[] pathList = annotation.path();
            if (ArrayUtils.isEmpty((Object[])pathList)) {
                log.error("bean name = {} has error requestMapping it is not standard.please make url start with {}", (Object)bean.getClass().getName(), (Object)urlPrefix);
            }
            for (Object path : pathList) {
                if (((String)path).startsWith(urlPrefix)) continue;
                log.error("bean name = {} error requestMapping it is not standard.please make url start with {}", (Object)bean.getClass().getName(), (Object)urlPrefix);
                continue block0;
            }
        }
    }

    private String getUrlPrefix(Environment environment) {
        return environment.getProperty("kjj.url.prefix");
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}

