/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.customweb.web.bind.impl;

import cn.com.duiba.kjy.base.customweb.exception.ArgResolverException;
import cn.com.duiba.kjy.base.customweb.util.ParamReflectUtil;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpRequest;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpResponse;
import cn.com.duiba.kjy.base.customweb.web.bean.ParameterBean;
import cn.com.duiba.kjy.base.customweb.web.bind.ArgsResolver;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.Order;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.ResponseBody;

@Order(value=-10)
public class PrimitiveParamResolver
implements ArgsResolver {
    @Resource
    private ConversionService conversionService;

    @Override
    public boolean canRead(Parameter parameter, Class<?> handlerMappingClass, Method handlerMappingMethod) {
        ResponseBody annotation = parameter.getAnnotation(ResponseBody.class);
        if (Objects.nonNull(annotation)) {
            return false;
        }
        RequestHeader requestHeader = parameter.getAnnotation(RequestHeader.class);
        if (Objects.nonNull(requestHeader)) {
            return false;
        }
        return ParamReflectUtil.isPrimitive(parameter.getType());
    }

    @Override
    public Object doResolver(ParameterBean parameterBean, KjjHttpRequest httpRequest, KjjHttpResponse response) {
        TypeDescriptor nested;
        String value = (String)httpRequest.getParamMap().getFirst((Object)parameterBean.getName());
        if (StringUtils.isBlank((CharSequence)value)) {
            value = parameterBean.getDefaultValue();
        }
        if (Objects.isNull(value)) {
            return null;
        }
        boolean canConvert = this.conversionService.canConvert(value.getClass(), parameterBean.getType());
        if (canConvert && Objects.nonNull(nested = TypeDescriptor.nested((MethodParameter)parameterBean.getMethodParameter(), (int)0))) {
            return this.conversionService.convert((Object)value, TypeDescriptor.forObject((Object)value), nested);
        }
        throw new ArgResolverException("can not convert parameter : url = " + httpRequest.uri() + "parameter = " + parameterBean.getName());
    }
}

