/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.kjj.oss.template;

import cn.com.duibaboot.kjj.oss.template.OssTemplate;
import cn.com.duibaboot.kjj.oss.template.operation.MultipartTask;
import cn.com.duibaboot.kjj.oss.template.operation.MultipartTaskImpl;
import cn.com.duibaboot.kjj.oss.template.util.OssUtils;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PutObjectResult;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public abstract class AbstractOssTemplate
implements OssTemplate,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(AbstractOssTemplate.class);
    protected OSSClient ossClient;
    protected String endPoint;
    protected String bucketName;
    protected String cdnDomain;
    protected String cdnHost;
    protected String bucketDomain;
    protected String bucketHost;
    @Resource
    private ExecutorService ossExecutorService;

    @Override
    public MultipartTask createMultipartTask() {
        return new MultipartTaskImpl(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <R> R downloadStream(String objectName, @NotNull Function<OSSObject, R> callback) {
        String key;
        if (StringUtils.isBlank((String)objectName)) {
            return null;
        }
        URI uri = URI.create(objectName);
        if (Objects.nonNull(uri.getHost())) {
            if (Objects.equals(uri.getHost(), this.cdnHost)) {
                key = uri.getPath().replaceFirst("/", "");
            } else {
                if (!Objects.equals(uri.getHost(), this.bucketHost)) {
                    log.error("\u975e\u6cd5\u7684Oss\u4e0b\u8f7d\u5730\u5740\uff1a{}.  this template cdnDomain={} endpoint={} bucket={}", new Object[]{objectName, this.cdnDomain, this.endPoint, this.bucketName});
                    return null;
                }
                key = uri.getPath().replaceFirst("/", "");
            }
        } else {
            key = objectName;
        }
        OssUtils.validatorObjectName(key);
        OSSObject object = this.ossClient.getObject(this.bucketName, key);
        try {
            R r = callback.apply(object);
            return r;
        }
        finally {
            InputStream objectContent = object.getObjectContent();
            try {
                objectContent.close();
            }
            catch (IOException e) {
                log.warn("close input stream error after upload input stream oss to oss!", (Throwable)e);
            }
        }
    }

    @Override
    public String getObjectName(String ossUrl) {
        if (StringUtils.isBlank((String)ossUrl)) {
            return ossUrl;
        }
        URI uri = URI.create(ossUrl);
        if (Objects.isNull(uri.getHost())) {
            if (uri.getPath().startsWith("/")) {
                return uri.getPath().replaceFirst("/", "");
            }
            return uri.getPath();
        }
        if (StringUtils.equals((String)uri.getHost(), (String)this.cdnHost)) {
            return StringUtils.substringAfterLast((String)ossUrl, (String)(this.cdnHost + "/"));
        }
        if (StringUtils.equals((String)uri.getHost(), (String)this.bucketHost)) {
            return StringUtils.substringAfterLast((String)ossUrl, (String)(this.bucketHost + "/"));
        }
        return null;
    }

    @Override
    public String uploadStream(InputStream inputStream, String objectName, ObjectMetadata meta) {
        OssUtils.validatorObjectName(objectName);
        if (this.doesObjectExist(objectName)) {
            log.error("\u6587\u4ef6\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u652f\u6301\u8986\u76d6\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\u3002");
            return null;
        }
        PutObjectResult result = this.ossClient.putObject(this.bucketName, objectName, inputStream, meta);
        if (OssUtils.successful(result)) {
            return this.getUrl(objectName);
        }
        log.error("\u4e0a\u4f20oss\u53d1\u751f\u9519\u8bef.object name = {} msg = {}", (Object)objectName, (Object)OssUtils.getErrorMessage(result));
        return null;
    }

    @Override
    public String uploadFile(File file, String objectName, ObjectMetadata meta) {
        OssUtils.validatorObjectName(objectName);
        PutObjectResult result = this.ossClient.putObject(this.bucketName, objectName, file, meta);
        if (OssUtils.successful(result)) {
            return this.getUrl(objectName);
        }
        log.error("\u4e0a\u4f20oss\u53d1\u751f\u9519\u8bef.object name = {} msg = {}", (Object)objectName, (Object)OssUtils.getErrorMessage(result));
        return null;
    }

    @Override
    public String uploadString(String content, String objectName, ObjectMetadata meta) {
        if (StringUtils.isBlank((String)content)) {
            log.error("\u4e0a\u4f20oss\u53d1\u751f\u9519\u8bef:\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a.object name = {}", (Object)objectName);
            return null;
        }
        byte[] bytes = content.getBytes();
        if (meta.getContentLength() == 0L) {
            meta.setContentLength((long)bytes.length);
        }
        return this.uploadStream(new ByteArrayInputStream(bytes), objectName, meta);
    }

    protected String getBucketUri() {
        return this.bucketDomain + "/";
    }

    @Override
    public boolean doesObjectExist(String url) {
        String objectName = this.getObjectName(url);
        if (StringUtils.isBlank((String)url)) {
            throw new UnsupportedOperationException("objectName \u975e\u6cd5\uff01objectName=" + url);
        }
        return this.ossClient.doesObjectExist(this.bucketName, objectName);
    }

    @Override
    public String getUrlWithOutScheme(String objectName) {
        return this.getUrl(objectName).replace("https:", "").replace("http:", "");
    }

    @Override
    public String getCDNHost() {
        return this.cdnHost;
    }

    public OSSClient getOssClient() {
        return this.ossClient;
    }

    public String getEndPoint() {
        return this.endPoint;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getCdnDomain() {
        return this.cdnDomain;
    }

    public String getBucketDomain() {
        return this.bucketDomain;
    }

    public String getBucketHost() {
        return this.bucketHost;
    }

    public ExecutorService getOssExecutorService() {
        return this.ossExecutorService;
    }

    public void setOssClient(OSSClient ossClient) {
        this.ossClient = ossClient;
    }

    public void setEndPoint(String endPoint) {
        this.endPoint = endPoint;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public void setCdnDomain(String cdnDomain) {
        this.cdnDomain = cdnDomain;
    }

    public void setCdnHost(String cdnHost) {
        this.cdnHost = cdnHost;
    }

    public void setBucketDomain(String bucketDomain) {
        this.bucketDomain = bucketDomain;
    }

    public void setBucketHost(String bucketHost) {
        this.bucketHost = bucketHost;
    }

    public void setOssExecutorService(ExecutorService ossExecutorService) {
        this.ossExecutorService = ossExecutorService;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractOssTemplate)) {
            return false;
        }
        AbstractOssTemplate other = (AbstractOssTemplate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        OSSClient this$ossClient = this.getOssClient();
        OSSClient other$ossClient = other.getOssClient();
        if (this$ossClient == null ? other$ossClient != null : !this$ossClient.equals(other$ossClient)) {
            return false;
        }
        String this$endPoint = this.getEndPoint();
        String other$endPoint = other.getEndPoint();
        if (this$endPoint == null ? other$endPoint != null : !this$endPoint.equals(other$endPoint)) {
            return false;
        }
        String this$bucketName = this.getBucketName();
        String other$bucketName = other.getBucketName();
        if (this$bucketName == null ? other$bucketName != null : !this$bucketName.equals(other$bucketName)) {
            return false;
        }
        String this$cdnDomain = this.getCdnDomain();
        String other$cdnDomain = other.getCdnDomain();
        if (this$cdnDomain == null ? other$cdnDomain != null : !this$cdnDomain.equals(other$cdnDomain)) {
            return false;
        }
        String this$cdnHost = this.getCDNHost();
        String other$cdnHost = other.getCDNHost();
        if (this$cdnHost == null ? other$cdnHost != null : !this$cdnHost.equals(other$cdnHost)) {
            return false;
        }
        String this$bucketDomain = this.getBucketDomain();
        String other$bucketDomain = other.getBucketDomain();
        if (this$bucketDomain == null ? other$bucketDomain != null : !this$bucketDomain.equals(other$bucketDomain)) {
            return false;
        }
        String this$bucketHost = this.getBucketHost();
        String other$bucketHost = other.getBucketHost();
        if (this$bucketHost == null ? other$bucketHost != null : !this$bucketHost.equals(other$bucketHost)) {
            return false;
        }
        ExecutorService this$ossExecutorService = this.getOssExecutorService();
        ExecutorService other$ossExecutorService = other.getOssExecutorService();
        return !(this$ossExecutorService == null ? other$ossExecutorService != null : !this$ossExecutorService.equals(other$ossExecutorService));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractOssTemplate;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        OSSClient $ossClient = this.getOssClient();
        result = result * 59 + ($ossClient == null ? 43 : $ossClient.hashCode());
        String $endPoint = this.getEndPoint();
        result = result * 59 + ($endPoint == null ? 43 : $endPoint.hashCode());
        String $bucketName = this.getBucketName();
        result = result * 59 + ($bucketName == null ? 43 : $bucketName.hashCode());
        String $cdnDomain = this.getCdnDomain();
        result = result * 59 + ($cdnDomain == null ? 43 : $cdnDomain.hashCode());
        String $cdnHost = this.getCDNHost();
        result = result * 59 + ($cdnHost == null ? 43 : $cdnHost.hashCode());
        String $bucketDomain = this.getBucketDomain();
        result = result * 59 + ($bucketDomain == null ? 43 : $bucketDomain.hashCode());
        String $bucketHost = this.getBucketHost();
        result = result * 59 + ($bucketHost == null ? 43 : $bucketHost.hashCode());
        ExecutorService $ossExecutorService = this.getOssExecutorService();
        result = result * 59 + ($ossExecutorService == null ? 43 : $ossExecutorService.hashCode());
        return result;
    }

    public String toString() {
        return "AbstractOssTemplate(ossClient=" + this.getOssClient() + ", endPoint=" + this.getEndPoint() + ", bucketName=" + this.getBucketName() + ", cdnDomain=" + this.getCdnDomain() + ", cdnHost=" + this.getCDNHost() + ", bucketDomain=" + this.getBucketDomain() + ", bucketHost=" + this.getBucketHost() + ", ossExecutorService=" + this.getOssExecutorService() + ")";
    }
}

