package cn.com.duiba.kjy.base.api.bean.es;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;
import java.util.Map;

/**
 * @author linjianhui
 * @description 查询过滤条件
 * @date 2020-02-07 15:25
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class QueryCriteria<T> extends BaseCriteria {

    private static final long serialVersionUID = -493352971702237451L;

    /**
     * 字段名
     */
    private String fieldName;

    /**
     * 字段值
     */
    private T fieldValue;

    /**
     * 批量匹配查询,EsQueryMode.TERMS_QUERY
     */
    private List<T> listValue;

    /**
     * 匹配模式
     */
    private EsMatchMode matchMode;

    /**
     * 查询模式
     */
    private EsQueryMode queryMode;

    /**
     * 扩充使用
     */
    private Map<String, Object> extra;


    /**
     * 有序的扩充使用extraKey
     */
    private List<String> extraKey;

    /**
     * 扩充使用
     */
    private Map<String, QueryCriteriaBean> extraQueryBeanMap;

    public QueryCriteria(String fieldName, T fieldValue) {
        this(fieldName, fieldValue, EsMatchMode.MUST,EsQueryMode.MATCH_QUERY);
    }

    public QueryCriteria(String fieldName, T fieldValue, EsQueryMode queryMode) {
        this(fieldName, fieldValue, EsMatchMode.MUST,queryMode);
    }

    public QueryCriteria(String fieldName, T fieldValue, EsMatchMode matchMode) {
        this(fieldName, fieldValue, matchMode,EsQueryMode.MATCH_QUERY);
    }

    public QueryCriteria(String fieldName, T fieldValue, EsMatchMode matchMode, EsQueryMode queryMode) {
        this.fieldName = fieldName;
        this.fieldValue = fieldValue;
        this.queryMode = queryMode;
        this.matchMode = matchMode;
    }

    public QueryCriteria(String fieldName, EsMatchMode matchMode, EsQueryMode queryMode, List<T> listValue) {
        this.fieldName = fieldName;
        this.listValue = listValue;
        this.queryMode = queryMode;
        this.matchMode = matchMode;
    }

    public QueryCriteria(String esId, List<String> esIds, EsMatchMode must, EsQueryMode termQuery) {
        super();
    }
}
