package cn.com.duiba.kjy.base.api.utils.login;

import cn.com.duiba.kjy.base.api.bean.login.LoginBean;
import cn.com.duiba.kjy.base.api.bean.login.LoginConstant;
import cn.com.duiba.wolf.utils.BlowfishUtils;
import com.alibaba.fastjson.JSON;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.time.DateUtils;

import java.util.Date;
import java.util.Objects;

/**
 * @author dugq
 * @date 2020/12/28 8:49 下午
 */
public class TokenUtils {

    public static String encodeToken(LoginBean loginBean) {
        if (Objects.isNull(loginBean)){
            return null;
        }
        loginBean.setDisableTime(DateUtils.addDays(new Date(),LoginConstant.LOGIN_CKE_MP_EXPIRY_DAYS).getTime());
        return BlowfishUtils.encryptBlowfish(JSON.toJSONString(loginBean), LoginConstant.KEY_ENCRYPT);
    }

    public static <T extends LoginBean>  T decodeToken(String value ,Class<T> clazz) {
        if (StringUtils.isBlank(value)){
            return null;
        }
        final String decodeStr = BlowfishUtils.decryptBlowfish(value, LoginConstant.KEY_ENCRYPT);
        return JSON.parseObject(decodeStr,clazz);
    }

}
