/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.api.utils.login;

import cn.com.duiba.boot.utils.SpringEnvironmentUtils;
import cn.com.duiba.kjy.base.api.bean.login.LoginBean;
import cn.com.duiba.kjy.base.api.enums.login.UserSourceEnum;
import cn.com.duiba.kjy.base.api.utils.login.TokenUtils;
import cn.com.duiba.wolf.perf.timeprofile.RequestTool;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.util.Asserts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseRequestUtil {
    private static final Logger log = LoggerFactory.getLogger(BaseRequestUtil.class);
    private static ThreadLocal<HttpRequestDto> local = new ThreadLocal();

    private BaseRequestUtil() {
    }

    public static void initHttp(HttpServletRequest request, HttpServletResponse response, UserSourceEnum ... userSourceEnums) {
        BaseRequestUtil.clearThreadLocally();
        Asserts.notNull((Object)request, (String)"RequestTool\u6ce8\u5165request\u4e3a\u7a7a");
        Asserts.notNull((Object)response, (String)"RequestTool\u6ce8\u5165response\u4e3a\u7a7a");
        BaseRequestUtil.get().initTokenUser(request, response, userSourceEnums);
    }

    private static void clearThreadLocally() {
        local.remove();
    }

    public static String getIp() {
        return BaseRequestUtil.get().ip;
    }

    public static boolean isLogin(UserSourceEnum userSourceEnum) {
        return BaseRequestUtil.get().getLoginStatus().getOrDefault((Object)userSourceEnum, false);
    }

    public static <T> T getUserInfo(UserSourceEnum userSourceEnum) {
        if (!BaseRequestUtil.isLogin(userSourceEnum)) {
            return null;
        }
        HttpRequestDto httpRequestDto = BaseRequestUtil.get();
        return (T)httpRequestDto.getLoginBean().get((Object)userSourceEnum);
    }

    public static HttpServletRequest getRequest() {
        return BaseRequestUtil.get().getRequest();
    }

    private static HttpRequestDto get() {
        HttpRequestDto httpRequestDto = local.get();
        if (null == httpRequestDto) {
            httpRequestDto = new HttpRequestDto();
            local.set(httpRequestDto);
        }
        return httpRequestDto;
    }

    private static class HttpRequestDto {
        private String ip;
        private HttpServletRequest request;
        private HttpServletResponse response;
        private Map<UserSourceEnum, LoginBean> loginBean = new HashMap<UserSourceEnum, LoginBean>();
        private Map<UserSourceEnum, Boolean> loginStatus = new HashMap<UserSourceEnum, Boolean>();

        void initTokenUser(HttpServletRequest request, HttpServletResponse response, UserSourceEnum ... userSourceEnums) {
            this.request = request;
            this.response = response;
            if (ArrayUtils.isEmpty((Object[])userSourceEnums)) {
                this.init(request, UserSourceEnum.values());
                return;
            }
            this.init(request, userSourceEnums);
        }

        private void init(HttpServletRequest request, UserSourceEnum ... supportUserSource) {
            this.ip = RequestTool.getIpAddr((HttpServletRequest)request);
            for (UserSourceEnum userSourceEnum : supportUserSource) {
                if (Objects.isNull((Object)userSourceEnum)) continue;
                this.loginBean.put(userSourceEnum, this.rollbackEncodeToken(request, userSourceEnum));
                this.loginStatus.put(userSourceEnum, true);
            }
        }

        private LoginBean rollbackEncodeToken(HttpServletRequest request, UserSourceEnum userSourceEnum) {
            String encodeString = RequestTool.getCookie((HttpServletRequest)request, (String)userSourceEnum.getCookieName());
            if (StringUtils.isBlank((String)encodeString)) {
                encodeString = request.getHeader(userSourceEnum.getCookieName());
            }
            if (!SpringEnvironmentUtils.isProdEnv()) {
                encodeString = request.getParameter(userSourceEnum.getCookieName());
            }
            if (StringUtils.isBlank((String)encodeString)) {
                return null;
            }
            LoginBean loginBean = TokenUtils.decodeToken(encodeString, userSourceEnum.getBeanClass());
            if (Objects.isNull(loginBean)) {
                return null;
            }
            if (loginBean.getDisableTime() < System.currentTimeMillis()) {
                return null;
            }
            return loginBean;
        }

        public String getIp() {
            return this.ip;
        }

        public HttpServletRequest getRequest() {
            return this.request;
        }

        public HttpServletResponse getResponse() {
            return this.response;
        }

        public Map<UserSourceEnum, LoginBean> getLoginBean() {
            return this.loginBean;
        }

        public Map<UserSourceEnum, Boolean> getLoginStatus() {
            return this.loginStatus;
        }

        public void setIp(String ip) {
            this.ip = ip;
        }

        public void setRequest(HttpServletRequest request) {
            this.request = request;
        }

        public void setResponse(HttpServletResponse response) {
            this.response = response;
        }

        public void setLoginBean(Map<UserSourceEnum, LoginBean> loginBean) {
            this.loginBean = loginBean;
        }

        public void setLoginStatus(Map<UserSourceEnum, Boolean> loginStatus) {
            this.loginStatus = loginStatus;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HttpRequestDto)) {
                return false;
            }
            HttpRequestDto other = (HttpRequestDto)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$ip = this.getIp();
            String other$ip = other.getIp();
            if (this$ip == null ? other$ip != null : !this$ip.equals(other$ip)) {
                return false;
            }
            HttpServletRequest this$request = this.getRequest();
            HttpServletRequest other$request = other.getRequest();
            if (this$request == null ? other$request != null : !this$request.equals(other$request)) {
                return false;
            }
            HttpServletResponse this$response = this.getResponse();
            HttpServletResponse other$response = other.getResponse();
            if (this$response == null ? other$response != null : !this$response.equals(other$response)) {
                return false;
            }
            Map<UserSourceEnum, LoginBean> this$loginBean = this.getLoginBean();
            Map<UserSourceEnum, LoginBean> other$loginBean = other.getLoginBean();
            if (this$loginBean == null ? other$loginBean != null : !((Object)this$loginBean).equals(other$loginBean)) {
                return false;
            }
            Map<UserSourceEnum, Boolean> this$loginStatus = this.getLoginStatus();
            Map<UserSourceEnum, Boolean> other$loginStatus = other.getLoginStatus();
            return !(this$loginStatus == null ? other$loginStatus != null : !((Object)this$loginStatus).equals(other$loginStatus));
        }

        protected boolean canEqual(Object other) {
            return other instanceof HttpRequestDto;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $ip = this.getIp();
            result = result * 59 + ($ip == null ? 43 : $ip.hashCode());
            HttpServletRequest $request = this.getRequest();
            result = result * 59 + ($request == null ? 43 : $request.hashCode());
            HttpServletResponse $response = this.getResponse();
            result = result * 59 + ($response == null ? 43 : $response.hashCode());
            Map<UserSourceEnum, LoginBean> $loginBean = this.getLoginBean();
            result = result * 59 + ($loginBean == null ? 43 : ((Object)$loginBean).hashCode());
            Map<UserSourceEnum, Boolean> $loginStatus = this.getLoginStatus();
            result = result * 59 + ($loginStatus == null ? 43 : ((Object)$loginStatus).hashCode());
            return result;
        }

        public String toString() {
            return "BaseRequestUtil.HttpRequestDto(ip=" + this.getIp() + ", request=" + this.getRequest() + ", response=" + this.getResponse() + ", loginBean=" + this.getLoginBean() + ", loginStatus=" + this.getLoginStatus() + ")";
        }
    }
}

