package cn.com.duiba.kjy.base.api.bean.login;

import java.io.Serializable;
import java.util.Objects;

/**
 * @author dugq
 * @date 2021/11/29 3:25 下午
 */
public class LoginBean implements Serializable {
    private static final long serialVersionUID = -6349141124904133967L;

    /**
     * 登录时间
     * 兼容旧的业务所必须的
     * 目前只用于解密参数，兼容老版本tku，不支持set
     */
    @Deprecated
    private Long time;


    /**
     * 登录时间
     */
    private Long disableTime;

    /**
     * @see cn.com.duiba.kjy.base.api.enums.login.UserSourceEnum
     */
    private Integer userSource;

    public Integer getUserSource() {
        return userSource;
    }

    public void setUserSource(Integer userSource) {
        this.userSource = userSource;
    }

    public Long getDisableTime() {
        if (Objects.nonNull(disableTime)){
            return disableTime;
        }
        return time;
    }

    public void setDisableTime(Long disableTime) {
        this.disableTime = disableTime;
    }
}
