/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.api.request.iddecode;

import cn.com.duiba.kjy.base.api.enums.IdDecode;
import cn.com.duiba.kjy.base.api.request.iddecode.IdDecodeBean;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;

public class IdArgumentConvert
extends IdDecodeBean
implements HttpMessageConverter {
    public boolean canRead(Class clazz, MediaType mediaType) {
        return clazz.isAnnotationPresent(IdDecode.class);
    }

    public boolean canWrite(@NotNull Class clazz, MediaType mediaType) {
        return false;
    }

    public List<MediaType> getSupportedMediaTypes() {
        return Collections.singletonList(MediaType.ALL);
    }

    public Object read(@NotNull Class clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        String s = IOUtils.toString((InputStream)inputMessage.getBody());
        JSONObject jsonObject = JSONObject.parseObject((String)s);
        List<Field> allFields = this.getAllFields(clazz);
        this.deCodeEncodingFiled(jsonObject, allFields);
        return JSONObject.parseObject((String)jsonObject.toJSONString(), (Class)clazz);
    }

    private void deCodeEncodingFiled(JSONObject jsonObject, List<Field> declaredFields) {
        if (Objects.isNull(jsonObject)) {
            return;
        }
        for (Field field : declaredFields) {
            IdDecode annotation = field.getAnnotation(IdDecode.class);
            if (!Objects.nonNull(annotation)) continue;
            if (this.isPrimitiveOrString(field.getType())) {
                Long id = this.decodeId(jsonObject.getString(field.getName()), field.getType(), field.getName());
                jsonObject.put(field.getName(), (Object)id);
                continue;
            }
            if (this.isMap(field.getType()).booleanValue()) {
                throw new UnsupportedOperationException("\u4e0d\u652f\u6301map\u54e6\u3002\u4e0d\u5efa\u8bae\u5165\u53c2\u4f7f\u7528map\u63a5\u6536");
            }
            if (this.isArray(field.getType()).booleanValue() || this.isCollection(field.getType()).booleanValue()) {
                JSONArray jsonArray = jsonObject.getJSONArray(field.getName());
                if (Objects.isNull(jsonArray) || annotation.type() == Object.class) continue;
                if (this.isPrimitiveOrString(annotation.type())) {
                    List ids = jsonArray.stream().map(value -> this.decodeId(value.toString(), field.getType(), field.getName())).collect(Collectors.toList());
                    jsonObject.put(field.getName(), ids);
                    continue;
                }
                if (this.isArray(annotation.type()).booleanValue() || this.isCollection(annotation.type()).booleanValue() || this.isMap(annotation.type()).booleanValue()) {
                    throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u77e9\u9635");
                }
                for (int i = 0; i < jsonArray.size(); ++i) {
                    this.deCodeEncodingFiled(jsonArray.getJSONObject(i), this.getAllFields(annotation.type()));
                }
                continue;
            }
            this.deCodeEncodingFiled(jsonObject.getJSONObject(field.getName()), this.getAllFields(field.getType()));
        }
    }

    public void write(Object o, MediaType contentType, HttpOutputMessage outputMessage) throws HttpMessageNotWritableException {
    }
}

