package cn.com.duiba.kjy.base.api.request.iddecode;

import cn.com.duiba.kjy.base.api.enums.IdDecode;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * POST请求的ID解密
 * Created by dugq on 2019-05-13.
 */
public class IdArgumentConvert extends IdDecodeBean implements HttpMessageConverter {


    @Override
    public boolean canRead(Class clazz, MediaType mediaType) {
        return clazz.isAnnotationPresent(IdDecode.class);
    }

    @Override
    public boolean canWrite(@NotNull Class clazz, MediaType mediaType) {
        return false;
    }

    @Override
    public List<MediaType> getSupportedMediaTypes() {
        return Collections.singletonList(MediaType.ALL);
    }

    @Override
    public Object read(@NotNull Class clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        String s = IOUtils.toString(inputMessage.getBody());
        JSONObject jsonObject = JSONObject.parseObject(s);
        List<Field> allFields = getAllFields(clazz);
        deCodeEncodingFiled(jsonObject, allFields);
        return JSONObject.parseObject(jsonObject.toJSONString(),clazz);
    }

    private void deCodeEncodingFiled(JSONObject jsonObject, List<Field> declaredFields) {
        if(Objects.isNull(jsonObject)){
            return;
        }
        for (Field field : declaredFields){
            IdDecode annotation = field.getAnnotation(IdDecode.class);
            if(Objects.nonNull(annotation)){ //标注了需要解密的属性
                if(isPrimitiveOrString(field.getType())){ //基本类型直接替换json的值
                    Long id = decodeId(jsonObject.getString(field.getName()), field.getType(),field.getName());
                    jsonObject.put(field.getName(),id);
                }else if(isMap(field.getType())){
                   throw new UnsupportedOperationException("不支持map哦。不建议入参使用map接收");
                }else if(isArray(field.getType()) || isCollection(field.getType())){ //数组 集合类型 不支持map
                    JSONArray jsonArray = jsonObject.getJSONArray(field.getName());
                    if(Objects.isNull(jsonArray)){
                        continue;
                    }
                    if (annotation.type() == Object.class){
                        continue;
                    }
                    if(isPrimitiveOrString(annotation.type())){
                        List<Long> ids = jsonArray.stream().map(value -> decodeId(value.toString(), field.getType(),field.getName())).collect(Collectors.toList());
                        jsonObject.put(field.getName(),ids);
                    }else if(isArray(annotation.type()) || isCollection(annotation.type()) || isMap(annotation.type())){
                        throw new UnsupportedOperationException("不支持矩阵");
                    }else{
                        for (int i =0 ;i < jsonArray.size(); i++){
                            deCodeEncodingFiled(jsonArray.getJSONObject(i),getAllFields(annotation.type()));
                        }
                    }
                }else{  //object 对象类型 递归
                    deCodeEncodingFiled(jsonObject.getJSONObject(field.getName()),getAllFields(field.getType()));
                }
            }
        }
    }

    @Override
    public void write(Object o, MediaType contentType, HttpOutputMessage outputMessage) throws HttpMessageNotWritableException {
    }
}
