package cn.com.duiba.kjy.base.customweb.autoconfig;

import cn.com.duiba.kjy.base.customweb.sever.KjjAnnotationConfigApplicationContext;
import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.loadbalancer.IPing;
import com.netflix.loadbalancer.IPingStrategy;
import com.netflix.loadbalancer.IRule;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.cloud.netflix.ribbon.SpringClientFactory;
import org.springframework.cloud.openfeign.CustomFeignClientsRegistrar;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextRefreshedEvent;

import javax.annotation.Resource;
import java.util.Set;

/**
 * 扩展ext对ribbon的扩展。
 * {@link cn.com.duibaboot.ext.autoconfigure.cloud.netflix.ribbon.RibbonCustomAutoConfiguration}
 * @author dugq
 * @date 2021/8/22 9:20 下午
 */
@Configuration
@ConditionalOnClass({IPing.class, IRule.class, ILoadBalancer.class, IPingStrategy.class})
public class KjjRibbonCustomAutoConfiguration {
    @Resource
    private SpringClientFactory springClientFactory;

    /**
     * 扫描所有Feign客户端名，并初始化ribbon。以防止启动后第一次进行Feign调用很慢的问题。
     * @return
     */
    @Bean
    public ApplicationListener<ContextRefreshedEvent> kjjSpringClientFactoryInitListener(){
        return new ApplicationListener<ContextRefreshedEvent>() {
            @Override
            public void onApplicationEvent(ContextRefreshedEvent event) {
                //扫描所有FeignClient并初始化！！每个大约要两秒，所以要并发运行
                if(event.getApplicationContext() instanceof KjjAnnotationConfigApplicationContext) {//只在主ApplicationContext中运行，以防止死循环
                    Set<String> enabledFeignClientNames = CustomFeignClientsRegistrar.getEnabledFeignClientNames();
//                    if(enabledFeignClientNames.size() <= 2){
                    for(final String name : enabledFeignClientNames) {
                        springClientFactory.getClientConfig(name);
                    }
                }
            }
        };
    }

}
