package cn.com.duiba.kjy.base.customweb.web.handler.mapping.controller;


import cn.com.duiba.kjy.base.customweb.web.adaptor.RequestHandlerMappingAdaptor;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpRequest;
import cn.com.duiba.kjy.base.customweb.web.handler.mapping.RequestMappingsRegister;
import org.springframework.context.support.ApplicationObjectSupport;

import javax.annotation.Resource;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * @author dugq
 * @date 2021/3/29 3:37 下午
 */
public class ControllerMappingRegister extends ApplicationObjectSupport implements RequestMappingsRegister {
    @Resource
    private RequestHandlerMappingAdaptor requestHandlerMappingAdaptor;

    private final Map<RequestMappingInfo, ControllerMappingHandler> HANDLER_MAPPING_BEAN_MAP = new HashMap<>();

    private final Map<String,RequestMappingInfo> cache = new HashMap<>();

    public void registerHandler(ControllerMappingHandler controllerMappingHandler) {
        if (Objects.isNull(controllerMappingHandler)){
            return;
        }
        HANDLER_MAPPING_BEAN_MAP.put(controllerMappingHandler.getRequestMappingInfo(), controllerMappingHandler);
    }

    @Override
    public Object getHandler(KjjHttpRequest fullHttpRequest){
        final String path = fullHttpRequest.getUri().getPath();
        final RequestMappingInfo requestMappingInfo = cache.get(path);
        if (Objects.isNull(requestMappingInfo)){
            final RequestMappingInfo reqMapping = getReqMapping(fullHttpRequest);
            if (Objects.nonNull(reqMapping)){
                cache.put(path,reqMapping);
                return resolverHandler(reqMapping);
            }
        }else{
            final boolean matchingCondition = requestMappingInfo.getMatchingCondition(fullHttpRequest);
            if (matchingCondition){
                return resolverHandler(requestMappingInfo);
            }else{
                final RequestMappingInfo reqMapping = getReqMapping(fullHttpRequest);
                if (Objects.nonNull(reqMapping)){
                    cache.put(path,reqMapping);
                    return resolverHandler(reqMapping);
                }
            }
        }
        return null;
    }

    private Object resolverHandler(RequestMappingInfo reqMapping) {
        final ControllerMappingHandler controllerMappingHandler = HANDLER_MAPPING_BEAN_MAP.get(reqMapping);
        if (Objects.nonNull(controllerMappingHandler) && Objects.isNull(controllerMappingHandler.getHandlerObject())){
            try {
                final Object handlerBean = obtainApplicationContext().getBean(controllerMappingHandler.getHandler());
                controllerMappingHandler.setHandlerObject(handlerBean);
            }catch (Exception e){
                return null;
            }
        }
        return controllerMappingHandler;
    }

    private RequestMappingInfo getReqMapping(KjjHttpRequest fullHttpRequest){
        for (RequestMappingInfo requestMappingInfo : HANDLER_MAPPING_BEAN_MAP.keySet()) {
            final boolean matchingCondition = requestMappingInfo.getMatchingCondition(fullHttpRequest);
            if (matchingCondition){
                return requestMappingInfo;
            }
        }
        return null;
    }

    @Override
    public RequestHandlerMappingAdaptor getAdaptor(){
        return requestHandlerMappingAdaptor;
    }

    public Collection<ControllerMappingHandler> getHandlerList(){
        return HANDLER_MAPPING_BEAN_MAP.values();
    }
}
