package cn.com.duiba.kjy.base.reactive.convert;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.core.ResolvableType;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.MediaType;
import org.springframework.http.ReactiveHttpInputMessage;
import org.springframework.http.codec.HttpMessageReader;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @author dugq
 * @date 2021/3/12 6:47 下午
 */
@Slf4j
public class HttpReader extends IdDecodeBean implements HttpMessageReader<Object> {

    @Override
    public List<MediaType> getReadableMediaTypes() {
        return Collections.singletonList(MediaType.APPLICATION_JSON);
    }

    @Override
    public boolean canRead(ResolvableType elementType, MediaType mediaType) {
        final Annotation annotation = ((Class) elementType.getType()).getAnnotation(IdDecode.class);
        return Objects.nonNull(annotation);
    }

    private int maxInMemorySize = 256 * 1024;

    @Override
    public Mono<Object> readMono(@NotNull ResolvableType elementType, ReactiveHttpInputMessage message, @NotNull Map hints) {
       return DataBufferUtils
                .join(message.getBody(), this.maxInMemorySize).
                flatMap(dataBuffer -> Mono.justOrEmpty(decode(dataBuffer, elementType, hints)));
    }

    private Object decode(DataBuffer dataBuffer, ResolvableType elementType, Map hints) {
        try {
            final String requestBody = IOUtils.toString(dataBuffer.asInputStream(), "UTF-8");
            final Class clazz = (Class)elementType.getType();
            JSONObject jsonObject = JSONObject.parseObject(requestBody);
            List<Field> allFields = getAllFields(clazz);
            deCodeEncodingFiled(jsonObject, allFields);
            return JSONObject.parseObject(jsonObject.toJSONString(),clazz);
        } catch (IOException e) {
            log.error("there is something error when decode request body",e);
            return null;
        }
    }

    protected List<Field> getAllFields(Class clazz) {
        if(Objects.isNull(clazz) || clazz.isInterface()){
            return Collections.emptyList();
        }
        List<Field> fieldList = new ArrayList<>();
        while (clazz != Object.class) {
            fieldList.addAll(new ArrayList<>(Arrays.asList(clazz.getDeclaredFields())));
            clazz = clazz.getSuperclass();
        }
        return fieldList;

    }

    @Override
    public Flux read(ResolvableType elementType, ReactiveHttpInputMessage message, Map hints) {

        return null;
    }

    private void deCodeEncodingFiled(JSONObject jsonObject, List<Field> declaredFields) {//NOSONAR
        if(Objects.isNull(jsonObject)){
            return;
        }
        for (Field field : declaredFields){
            IdDecode annotation = field.getAnnotation(IdDecode.class);
            if(Objects.nonNull(annotation)){ //标注了需要解密的属性
                if(isPrimitiveOrString(field.getType())){ //基本类型直接替换json的值
                    Long id = decodeId(annotation, jsonObject.getString(field.getName()), field.getType(),field.getName());
                    jsonObject.put(field.getName(),id);
                }else if(isMap(field.getType())){
                    throw new UnsupportedOperationException("不支持map哦。不建议入参使用map接收");
                }else if(isArray(field.getType()) || isCollection(field.getType())){ //数组 集合类型 不支持map
                    JSONArray jsonArray = jsonObject.getJSONArray(field.getName());
                    if(Objects.isNull(jsonArray)){
                        continue;
                    }
                    if (annotation.type() == Object.class){
                        continue;
                    }
                    if(isPrimitiveOrString(annotation.type())){
                        List<Long> ids = jsonArray.stream().map(value -> decodeId(annotation, value.toString(), field.getType(),field.getName())).collect(Collectors.toList());
                        jsonObject.put(field.getName(),ids);
                    }else if(isArray(annotation.type()) || isCollection(annotation.type()) || isMap(annotation.type())){
                        throw new UnsupportedOperationException("不支持矩阵");
                    }else{
                        for (int i =0 ;i < jsonArray.size(); i++){
                            deCodeEncodingFiled(jsonArray.getJSONObject(i),getAllFields(annotation.type()));
                        }
                    }
                }else{  //object 对象类型 递归
                    deCodeEncodingFiled(jsonObject.getJSONObject(field.getName()),getAllFields(field.getType()));
                }
            }
        }
    }

}
