package cn.com.duiba.kjy.base.api.enums.login;

import cn.com.duiba.kjy.base.api.bean.login.LiveAuthBean;
import cn.com.duiba.kjy.base.api.bean.login.LoginBean;
import cn.com.duiba.kjy.base.api.bean.login.TkuBean;
import lombok.Getter;

/**
 * 客集集体系下的用户Cookie类型
 * 什么情况需要添加此枚举：
 * 和已经有的冲突：
 * cookie的名称或者value需要更换的时候
 * @author dugq
 * @date 2021/11/29 3:26 下午
 */
@Getter
public enum UserSourceEnum {
    KJJ_ACCOUNT(1,"tku", TkuBean.class,"客集集账号服务"),
    KJJ_LIVE(2,"authKey", LiveAuthBean.class,"客集集账号服务"),
    ;

    private final Integer type;
    private final String cookieName;
    private final Class<? extends LoginBean> beanClass;
    private final String desc;

    UserSourceEnum(Integer type,String cookieName,Class<? extends LoginBean> beanClass, String desc) {
        this.type = type;
        this.desc = desc;
        this.cookieName = cookieName;
        this.beanClass = beanClass;
    }

}
