package cn.com.duiba.kjy.base.api.utils;

import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

/**
 * md5 加密工具类
 * @author dugq
 * @date 2021/10/20 9:48 上午
 */
public final class MD5Util {

    private MD5Util() {
    }

    /**
     * Converts given string to MD5 hash
     *
     * @param str str to be hashed with MD5
     */
    @SuppressWarnings("checkstyle:magicnumber")
    public static String toMD5String(String str) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            if (md == null || str == null) {
                return null;
            }
            byte[] byteData = md.digest(str.getBytes(Charset.forName("UTF-8")));

            StringBuilder sb = new StringBuilder();
            for (byte aByteData : byteData) {
                sb.append(Integer.toString((aByteData & 0xff) + 0x100, 16).substring(1));
            }
            return sb.toString();
        } catch (NoSuchAlgorithmException ignored) {
            return null;
        }
    }
}
