package cn.com.duiba.kjy.base.api.utils.maskingphone;

import cn.com.duiba.kjy.base.api.utils.StringUtil;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;

import java.io.IOException;
import java.util.Objects;

/**
 * 使用jackson对脱敏后的手机号进行序列化
 *
 * @author likui
 * @date 2021/9/22 11:25 上午
 **/
public class PhoneJacksonSerializable extends JsonSerializer<String> {
    @Override
    public void serialize(String value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        if (Objects.nonNull(value)) {
            gen.writeString(StringUtil.masking(value, 3, 4, false));
        }
    }
}
