package cn.com.duiba.kjy.base.customweb.util;

import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpRequest;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

/**
 * @author dugq
 * @date 2021/4/1 5:03 下午
 */
public abstract class CorsUtils {

    /**
     * Returns {@code true} if the request is a valid CORS one by checking {@code Origin}
     * header presence and ensuring that origins are different.
     */
    public static boolean isCorsRequest(KjjHttpRequest request) {
        String origin = request.getHeader(HttpHeaders.ORIGIN);
        if (origin == null) {
            return false;
        }
        UriComponents originUrl = UriComponentsBuilder.fromOriginHeader(origin).build();
        String scheme = request.getUri().getScheme();
        String host = request.getUri().getHost();
        int port = request.getUri().getPort();
        return !(ObjectUtils.nullSafeEquals(scheme, originUrl.getScheme()) &&
                ObjectUtils.nullSafeEquals(host, originUrl.getHost()) &&
                getPort(scheme, port) == getPort(originUrl.getScheme(), originUrl.getPort()));

    }

    private static int getPort(@Nullable String scheme, int port) {
        if (port == -1) {
            if ("http".equals(scheme) || "ws".equals(scheme)) {
                port = 80;
            }
            else if ("https".equals(scheme) || "wss".equals(scheme)) {
                port = 443;
            }
        }
        return port;
    }

    /**
     * Returns {@code true} if the request is a valid CORS pre-flight one by checking {code OPTIONS} method with
     * {@code Origin} and {@code Access-Control-Request-Method} headers presence.
     */
    public static boolean isPreFlightRequest(KjjHttpRequest request) {
        return (HttpMethod.OPTIONS.matches(request.getMethod()) &&
                request.getHeader(HttpHeaders.ORIGIN) != null &&
                request.getHeader(HttpHeaders.ACCESS_CONTROL_REQUEST_METHOD) != null);
    }
}
